/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.DTDSpace;
import weblogic.xml.babel.scanner.ExternalID;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.SystemLiteral;

final class NotationDeclaration {
    private ScannerState state;
    private Name name;
    private DTDSpace space;
    private ExternalID externalID;
    private SystemLiteral pubidLiteral;

    NotationDeclaration(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
        this.space = new DTDSpace(scannerState);
        this.externalID = new ExternalID(scannerState);
        this.pubidLiteral = new SystemLiteral(scannerState);
    }

    public void read() throws IOException, ScannerException {
        this.space.checkedRead();
        this.state.pushToken(this.state.tokenFactory.createToken(55));
        this.name.read();
        this.space.checkedRead();
        if (!this.externalID.read()) {
            throw new ScannerException("A Notation declaration must contain a SYSTEM or PUBLIC ID.", this.state);
        }
        this.state.skipSpace();
        this.state.expect('>');
        this.state.pushToken(this.state.tokenFactory.createToken(39));
    }
}

