/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Token;

final class Name {
    private ScannerState state;
    private Token localName;
    private Token prefix;

    Name(ScannerState scannerState) {
        this.state = scannerState;
    }

    void read() throws IOException, ScannerException {
        this.localName = null;
        this.prefix = null;
        this.read(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void read(boolean bl) throws IOException, ScannerException {
        int n = 0;
        if (!Name.isNameBegin(this.state.currentChar)) {
            throw new ScannerException(" '" + this.state.currentChar + "' expected a valid beginning name character", this.state);
        }
        this.state.mark();
        this.state.read();
        ++n;
        while (XmlChars.isNameChar(this.state.currentChar)) {
            if (this.state.currentChar == ':') {
                if (bl) {
                    throw new ScannerException(" '" + this.state.currentChar + "' Already got a ':' in name", this.state);
                }
                this.prefix = this.state.createStoredToken(18, n);
                this.state.pushToken(this.prefix);
                this.state.read();
                this.read(true);
                return;
            }
            this.state.read();
            ++n;
        }
        this.localName = this.state.createStoredToken(0, n);
        this.state.pushToken(this.localName);
    }

    public Token getLocalName() {
        return this.localName;
    }

    public Token getPrefix() {
        return this.prefix;
    }

    /*
     * Enabled aggressive block sorting
     */
    String stringRead() throws IOException, ScannerException {
        int n = 0;
        if (!Name.isNameBegin(this.state.currentChar)) {
            throw new ScannerException(" '" + this.state.currentChar + "' expect a valid beginning name character", this.state);
        }
        this.state.mark();
        this.state.read();
        ++n;
        while (XmlChars.isNameChar(this.state.currentChar)) {
            this.state.read();
            ++n;
        }
        return this.state.getString(n);
    }

    public static boolean isNameBegin(char c) {
        return XmlChars.isLetter(c) || c == '_';
    }
}

