/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.dtd.DocumentTypeDefinition;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.Scanner;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

public class ValidatingBaseParser
extends BaseParser {
    protected boolean scanningDTD = false;
    protected DocumentTypeDefinition dtd;

    public ValidatingBaseParser() {
    }

    public ValidatingBaseParser(BaseParser baseParser) {
        this.setParent(baseParser);
    }

    public ValidatingBaseParser(Reader reader) throws IOException, ScannerException {
        super.init(reader);
    }

    public ValidatingBaseParser(InputStream inputStream) throws IOException, ScannerException {
        super.init(XmlReader.createReader(inputStream));
    }

    public ValidatingBaseParser(InputSource inputSource) throws IOException, ScannerException {
        super.init(inputSource);
    }

    public void initDTD(InputSource inputSource) throws IOException, ScannerException {
        super.init(inputSource);
    }

    public void setEntityTables(Scanner scanner, BaseParser baseParser) {
        ScannerState scannerState = scanner.getState();
        scannerState.setParameterEntityTable(baseParser.getParameterEntityTable());
        scannerState.setExternalEntityTable(baseParser.getExternalEntityTable());
        scannerState.setInternalEntityTable(baseParser.getInternalEntityTable());
    }

    protected void initScanner(Scanner scanner) throws IOException, ScannerException {
        if (this.dtd == null) {
            throw new ScannerException("SanityCheck: no dtd!");
        }
        if (this.isChild) {
            this.setEntityTables(scanner, this.parent);
        } else {
            this.setEntityTables(scanner, this);
        }
        scanner.setReadDTD();
        if (this.scanningDTD) {
            scanner.setExternalDTD(true);
        }
        this.prime();
    }

    public void setExternalDTD() {
        this.scanningDTD = true;
    }

    public DocumentTypeDefinition getDTD() {
        return this.dtd;
    }

    protected void init(Reader reader) throws IOException, ScannerException {
        this.dtd = new DocumentTypeDefinition();
        if (this.isChild) {
            this.dtd.setTables(this.parent.getParameterEntityTable(), this.parent.getExternalEntityTable(), this.parent.getInternalEntityTable());
        }
        super.init(reader);
    }

    protected Element parseProlog() throws IOException, ScannerException, ParseException {
        switch (this.currentToken.tokenType) {
            case 1: {
                if (this.readOneStartTag) {
                    throw new ParseException("All tags must be contained within a single element", this.scanner.getLine(), this.currentToken);
                }
                this.readOneStartTag = true;
                return this.parseElement();
            }
            case 7: 
            case 8: {
                return this.parseElement();
            }
            case 19: {
                this.space.parse(this);
                return this.space;
            }
            case 13: {
                this.cde.parse(this);
                if (this.cde.isSpace()) {
                    return this.cde;
                }
            }
            case -1: {
                this.eofElement.parse(this);
                return this.eofElement;
            }
            case 24: {
                this.dtd.parse(this);
                return this.parseElement();
            }
        }
        throw new ParseException("Expected a PI, SPACE, OPENTAG, or COMMENT ", this.scanner.getLine(), this.currentToken);
    }

    protected void processAttributes(StartElement startElement) {
        this.dtd.processAttributes(startElement);
        try {
            Iterator iterator = startElement.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                String string = attribute.getLocalName();
                if (!string.startsWith("xml:")) continue;
                this.putNamespaceURI(string, attribute.getValue());
            }
        }
        catch (SAXException sAXException) {}
    }

    public EntityTable getParameterEntityTable() {
        return this.dtd.getParameterEntityTable();
    }

    public EntityTable getInternalEntityTable() {
        return this.dtd.getInternalEntityTable();
    }

    public EntityTable getExternalEntityTable() {
        return this.dtd.getExternalEntityTable();
    }

    public static void main(String[] stringArray) {
        try {
            ValidatingBaseParser validatingBaseParser = new ValidatingBaseParser(new InputSource(new BufferedInputStream(new FileInputStream(stringArray[0]))));
            while (!validatingBaseParser.isEOF()) {
                Element element = validatingBaseParser.parseSome();
                System.out.println("[" + element.getLine() + "][" + Element.getString(element.type) + "][" + element + "]");
            }
        }
        catch (ScannerException scannerException) {
            System.out.println("-----SCANNER----");
            System.out.println(scannerException);
            scannerException.printStackTrace();
            scannerException.printTokenStack();
            scannerException.printErrorLine();
        }
        catch (ParseException parseException) {
            System.out.println("-----PARSER ----");
            System.out.println(parseException);
            parseException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("-----JAVA   ----");
            exception.printStackTrace();
        }
    }
}

