/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mortbay.io.bio.StreamEndPoint;

public class StringEndPoint
extends StreamEndPoint {
    String _encoding = "ISO8859_1";
    ByteArrayInputStream _bin = new ByteArrayInputStream(new byte[0]);
    ByteArrayOutputStream _bout = new ByteArrayOutputStream();

    public StringEndPoint() throws IOException {
        super(null, null);
        this._in = this._bin;
        this._out = this._bout;
    }

    public StringEndPoint(String encoding) throws IOException {
        this();
        if (encoding != null) {
            this._encoding = encoding;
        }
    }

    public void setInput(String s) {
        try {
            byte[] bytes = s.getBytes(this._encoding);
            this._bin = new ByteArrayInputStream(bytes);
            this._in = this._bin;
            this._bout = new ByteArrayOutputStream();
            this._out = this._bout;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public String getOutput() {
        try {
            String s = new String(this._bout.toByteArray(), this._encoding);
            this._bout.reset();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(this._encoding + ": " + e.toString());
        }
    }

    public boolean hasMore() {
        return this._bin.available() > 0;
    }
}

