/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.LocalMapStatsProvider;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.operation.EntryBackupOperation;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected Object oldValue;
    private EntryProcessor entryProcessor;
    private EntryEventType eventType;
    private Object response;
    private transient Object dataValue;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() {
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        this.oldValue = this.getValueFor(this.dataKey);
        Object key = this.toObject(this.dataKey);
        Object value = this.toObject(this.oldValue);
        Map.Entry entry = this.createMapEntry(key, value);
        this.response = this.process(entry);
        if (this.noOp(entry)) {
            return;
        }
        if (this.entryRemoved(entry, now)) {
            return;
        }
        this.entryAddedOrUpdated(entry, now);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.eventType == null) {
            return;
        }
        this.invalidateNearCaches();
        this.publishEntryEvent();
        this.publishWanReplicationEvent();
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public String toString() {
        return "EntryOperation{}";
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    private Object toObject(Object data) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toObject(data);
    }

    private Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private boolean noOp(Map.Entry entry) {
        MapEntrySimple mapEntrySimple = (MapEntrySimple)entry;
        return !mapEntrySimple.isModified() || this.oldValue == null && entry.getValue() == null;
    }

    private boolean entryRemoved(Map.Entry entry, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.remove(this.dataKey);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.eventType = this.pickEventTypeOrNull(entry);
            return true;
        }
        return false;
    }

    private boolean entryAddedOrUpdated(Map.Entry entry, long now) {
        Object value = entry.getValue();
        if (value != null) {
            this.put(value);
            this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
            this.eventType = this.pickEventTypeOrNull(entry);
            return true;
        }
        return false;
    }

    private EntryEventType pickEventTypeOrNull(Map.Entry entry) {
        Object value = entry.getValue();
        if (value == null) {
            return EntryEventType.REMOVED;
        }
        this.dataValue = value;
        if (this.oldValue == null) {
            return EntryEventType.ADDED;
        }
        MapEntrySimple mapEntrySimple = (MapEntrySimple)entry;
        if (mapEntrySimple.isModified()) {
            return EntryEventType.UPDATED;
        }
        return null;
    }

    private void put(Object value) {
        this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, value));
    }

    private Object getValueFor(Data dataKey) {
        return this.recordStore.getMapEntry(dataKey).getValue();
    }

    private Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    private Map.Entry createMapEntry(Object key, Object value) {
        return new MapEntrySimple<Object, Object>(key, value);
    }

    private LocalMapStatsImpl getLocalMapStats() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        return localMapStatsProvider.getLocalMapStatsImpl(this.name);
    }

    private boolean hasRegisteredListenerForThisMap() {
        String serviceName = this.mapService.getMapServiceContext().serviceName();
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration(serviceName, this.name);
    }

    private void nullifyOldValueIfNecessary() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
            this.oldValue = null;
        }
    }

    private void publishEntryEvent() {
        if (this.hasRegisteredListenerForThisMap()) {
            this.nullifyOldValueIfNecessary();
            MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
            this.dataValue = this.toData(this.dataValue);
            mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.toData(this.oldValue), (Data)this.dataValue);
        }
    }

    private void publishWanReplicationEvent() {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
        Data key = this.dataKey;
        if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
            mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
        } else {
            Record record = this.recordStore.getRecord(key);
            if (record != null) {
                this.dataValue = this.toData(this.dataValue);
                EntryView<Data, Object> entryView = EntryViews.createSimpleEntryView(key, this.dataValue, record);
                mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    private MapEventPublisher getMapEventPublisher() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapEventPublisher();
    }
}

