/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.impl.QueueOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ContainsOperation
extends QueueOperation {
    private Collection<Data> dataList;

    public ContainsOperation() {
    }

    public ContainsOperation(String name, Collection<Data> dataList) {
        super(name);
        this.dataList = dataList;
    }

    @Override
    public void run() throws Exception {
        this.response = this.getOrCreateContainer().contains(this.dataList);
    }

    @Override
    public void afterRun() throws Exception {
        this.getQueueService().getLocalQueueStatsImpl(this.name).incrementOtherOperations();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.dataList.size());
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            this.dataList.add(IOUtil.readData(in));
        }
    }

    @Override
    public int getId() {
        return 11;
    }
}

