/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettableResultFuture<C>
implements Future<C> {
    final Lock lock = new ReentrantLock();
    private Condition hasResult = this.lock.newCondition();
    private C result;
    private Throwable exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C get() throws InterruptedException, ExecutionException {
        if (this.result == null && this.exception == null) {
            this.lock.lock();
            try {
                while (this.result == null && this.exception == null) {
                    this.hasResult.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result == null && this.exception == null) {
            this.lock.lock();
            try {
                while (this.result == null && this.exception == null) {
                    if (this.hasResult.await(timeout, unit)) continue;
                    throw new TimeoutException();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(C result) {
        this.result = result;
        this.lock.lock();
        try {
            this.hasResult.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Throwable t) {
        this.exception = t;
        this.lock.lock();
        try {
            this.hasResult.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

