/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.harvest.HarvestStatistics;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpServerSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;

public class HostCandidateHarvester {
    private static final Logger logger = Logger.getLogger(HostCandidateHarvester.class.getName());
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public void harvest(Component component, int preferredPort, int minPort, int maxPort, Transport transport) throws IllegalArgumentException, IOException {
        this.harvestStatistics.startHarvestTiming();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        boolean isIPv6Disabled = StackProperties.getBoolean("org.ice4j.ipv6.DISABLED", false);
        if (transport != Transport.UDP && transport != Transport.TCP) {
            throw new IllegalArgumentException("Transport protocol not supported: " + (Object)((Object)transport));
        }
        boolean boundAtLeastOneSocket = false;
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface)) continue;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                IceSocketWrapper sock;
                block7: {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address) && isIPv6Disabled) continue;
                    sock = null;
                    try {
                        if (transport == Transport.UDP) {
                            sock = this.createDatagramSocket(addr, preferredPort, minPort, maxPort);
                            boundAtLeastOneSocket = true;
                            break block7;
                        }
                        if (transport != Transport.TCP) break block7;
                        if (addr instanceof Inet6Address) continue;
                        sock = this.createServerSocket(addr, preferredPort, minPort, maxPort, component);
                        boundAtLeastOneSocket = true;
                    }
                    catch (IOException exc) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.warning("Failed to create a socket for:\naddr:" + addr + "\npreferredPort:" + preferredPort + "\nminPort:" + minPort + "\nmaxPort:" + maxPort + "\nprotocol:" + (Object)((Object)transport) + "\nContinuing with next address");
                        continue;
                    }
                }
                HostCandidate candidate = new HostCandidate(sock, component, transport);
                candidate.setVirtual(NetworkUtils.isInterfaceVirtual(iface));
                component.addLocalCandidate(candidate);
                if (transport == Transport.TCP) continue;
                this.createAndRegisterStunSocket(candidate);
            }
        }
        if (!boundAtLeastOneSocket) {
            throw new IOException("Failed to bind even a single host candidate for component:" + component + " preferredPort=" + preferredPort + " minPort=" + minPort + " maxPort=" + maxPort);
        }
        this.harvestStatistics.stopHarvestTiming(component.getLocalCandidateCount());
    }

    private IceSocketWrapper createServerSocket(InetAddress laddr, int preferredPort, int minPort, int maxPort, Component component) throws IllegalArgumentException, IOException, BindException {
        this.checkPorts(preferredPort, minPort, maxPort);
        int bindRetries = StackProperties.getInt("org.ice4j.BIND_RETRIES", 50);
        int port = preferredPort;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                ServerSocket sock = new ServerSocket();
                sock.setReuseAddress(true);
                sock.bind(new InetSocketAddress(laddr, port));
                IceTcpServerSocketWrapper socket = new IceTcpServerSocketWrapper(sock, component);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "just bound to: " + sock.getLocalSocketAddress());
                }
                return socket;
            }
            catch (SocketException se) {
                logger.log(Level.INFO, "Retrying a bind because of a failure to bind to address " + laddr + " and port " + port + " (" + se.getMessage() + ")");
                logger.log(Level.INFO, "", se);
                if (++port <= maxPort) continue;
                port = minPort;
                continue;
            }
        }
        throw new BindException("Could not bind to any port between " + minPort + " and " + (port - 1));
    }

    private IceSocketWrapper createDatagramSocket(InetAddress laddr, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        this.checkPorts(preferredPort, minPort, maxPort);
        int bindRetries = StackProperties.getInt("org.ice4j.BIND_RETRIES", 50);
        int port = preferredPort;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                IceUdpSocketWrapper sock = new IceUdpSocketWrapper(new MultiplexingDatagramSocket(port, laddr));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "just bound to: " + ((IceSocketWrapper)sock).getLocalSocketAddress());
                }
                return sock;
            }
            catch (SocketException se) {
                logger.log(Level.INFO, "Retrying a bind because of a failure to bind to address " + laddr + " and port " + port + " (" + se.getMessage() + ")");
                logger.log(Level.FINEST, "", se);
                if (++port <= maxPort) continue;
                port = minPort;
                continue;
            }
        }
        throw new BindException("Could not bind to any port between " + minPort + " and " + (port - 1));
    }

    private void createAndRegisterStunSocket(HostCandidate candidate) {
        IceSocketWrapper stunSocket = candidate.getStunSocket(null);
        candidate.getStunStack().addSocket(stunSocket);
    }

    private void checkPorts(int preferredPort, int minPort, int maxPort) throws IllegalArgumentException {
        if (!NetworkUtils.isValidPortNumber(minPort) || !NetworkUtils.isValidPortNumber(maxPort)) {
            throw new IllegalArgumentException("minPort (" + minPort + ") and maxPort (" + maxPort + ") " + "should be integers between 1024 and 65535.");
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException("minPort (" + minPort + ") should be less than or " + "equal to maxPort (" + maxPort + ")");
        }
        if (minPort > preferredPort || preferredPort > maxPort) {
            throw new IllegalArgumentException("preferredPort (" + preferredPort + ") must be between minPort (" + minPort + ") and maxPort (" + maxPort + ")");
        }
    }

    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }
}

