/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.ActionConstants;
import java.io.IOException;
import java.security.Permission;

public class ClientDestroyRequest
extends CallableClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;
    private String serviceName;

    public ClientDestroyRequest() {
    }

    public ClientDestroyRequest(String name, String serviceName) {
        this.name = name;
        this.serviceName = serviceName;
    }

    public Object call() throws Exception {
        this.getClientEngine().getProxyService().destroyDistributedObject(this.getServiceName(), this.name);
        return null;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("s", this.serviceName);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.serviceName = reader.readUTF("s");
    }

    @Override
    public Permission getRequiredPermission() {
        return ActionConstants.getPermission(this.name, this.serviceName, "destroy");
    }
}

