/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.Iterator;
import org.dom4j.Element;
import org.xmpp.packet.Packet;

public class Presence
extends Packet {
    public Presence() {
        super(docFactory.createDocument().addElement("presence"));
    }

    public Presence(Element element) {
        super(element);
    }

    public boolean isAvailable() {
        return this.getType() == null;
    }

    public Type getType() {
        String string = this.element.attributeValue("type");
        if (string == null) {
            return null;
        }
        return Type.valueOf(string);
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toString());
    }

    public Show getShow() {
        String string = this.element.elementText("show");
        if (string == null) {
            return null;
        }
        return Show.valueOf(string);
    }

    public void setShow(Show show) {
        Element element = this.element.element("show");
        if (show == null && element != null) {
            this.element.remove(element);
            return;
        }
        if (element == null) {
            if (!this.isAvailable()) {
                throw new IllegalArgumentException("Cannot set 'show' if 'type' attribute is set.");
            }
            element = this.element.addElement("show");
        }
        element.setText(show.toString());
    }

    public String getStatus() {
        return this.element.elementText("status");
    }

    public void setStatus(String string) {
        Element element = this.element.element("status");
        if (string == null && element != null) {
            this.element.remove(element);
            return;
        }
        if (element == null) {
            element = this.element.addElement("status");
        }
        element.setText(string);
    }

    public int getPriority() {
        String string = this.element.elementText("priority");
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setPriority(int n) {
        if (n < -128 || n > 128) {
            throw new IllegalArgumentException("Priority value of " + n + " is outside the valid range of -128 through 128");
        }
        Element element = this.element.element("priority");
        if (element == null) {
            element = this.element.addElement("priority");
        }
        element.setText(Integer.toString(n));
    }

    public Element getChildElement(String string, String string2) {
        Iterator iterator = this.element.elementIterator(string);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!element.getNamespaceURI().equals(string2)) continue;
            return element;
        }
        return null;
    }

    public Element addChildElement(String string, String string2) {
        return this.element.addElement(string, string2);
    }

    public Presence createCopy() {
        Element element = this.element.createCopy();
        docFactory.createDocument().add(this.element.createCopy());
        return new Presence(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Show {
        chat,
        away,
        xa,
        dnd;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        probe,
        error;

    }
}

