/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import org.jivesoftware.stringprep.IDNA;
import org.jivesoftware.stringprep.Stringprep;

public class JID
implements Comparable {
    private String node;
    private String domain;
    private String resource;

    public JID(String string) {
        if (string == null) {
            throw new NullPointerException("JID cannot be null");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("@");
        int n2 = string.indexOf("/");
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if (n + 1 > string.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        string3 = n < 0 ? (n2 > 0 ? string.substring(0, n2) : string) : (n2 > 0 ? string.substring(n + 1, n2) : string.substring(n + 1));
        string4 = n2 + 1 > string.length() || n2 < 0 ? null : string.substring(n2 + 1);
        this.init(string2, string3, string4);
    }

    public JID(String string, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        this.init(string, string2, string3);
    }

    JID(String string, Object object) {
        object = null;
        if (string == null) {
            throw new NullPointerException("JID cannot be null");
        }
        int n = string.indexOf("@");
        int n2 = string.indexOf("/");
        if (n > 0) {
            this.node = string.substring(0, n);
        }
        if (n + 1 > string.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        this.domain = n < 0 ? (n2 > 0 ? string.substring(0, n2) : string) : (n2 > 0 ? string.substring(n + 1, n2) : string.substring(n + 1));
        this.resource = n2 + 1 > string.length() || n2 < 0 ? null : string.substring(n2 + 1);
    }

    private void init(String string, String string2, String string3) {
        if (string != null && string.equals("")) {
            string = null;
        }
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        try {
            this.node = Stringprep.nodeprep(string);
            this.domain = Stringprep.nameprep(IDNA.toASCII(string2), false);
            this.resource = Stringprep.resourceprep(string3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal JID format: " + exception.getMessage());
        }
        if (string != null && string.length() * 2 > 1023) {
            throw new IllegalArgumentException("Node cannot be larger than 1023 bytes. Size is " + string.length() * 2 + " bytes.");
        }
        if (string2.length() * 2 > 1023) {
            throw new IllegalArgumentException("Domain cannot be larger than 1023 bytes. Size is " + string2.length() * 2 + " bytes.");
        }
        if (string3 != null && string3.length() * 2 > 1023) {
            throw new IllegalArgumentException("Resource cannot be larger than 1023 bytes. Size is " + string3.length() * 2 + " bytes.");
        }
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.node != null) {
            stringBuffer.append(this.node).append("@");
        }
        stringBuffer.append(this.domain);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.node != null) {
            stringBuffer.append(this.node).append("@");
        }
        stringBuffer.append(this.domain);
        if (this.resource != null) {
            stringBuffer.append("/").append(this.resource);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        JID jID = (JID)object;
        if (this.node != null ? !this.node.equals(jID.node) : jID.node != null) {
            return false;
        }
        if (!this.domain.equals(jID.domain)) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(jID.resource) : jID.resource != null);
    }

    public int compareTo(Object object) {
        if (!(object instanceof JID)) {
            throw new ClassCastException("Ojbect not instanceof JID: " + object);
        }
        JID jID = (JID)object;
        int n = this.domain.compareTo(jID.domain);
        if (n == 0 && this.node != null && jID.node != null) {
            n = this.node.compareTo(jID.node);
        }
        if (n == 0 && this.resource != null && jID.resource != null) {
            n = this.resource.compareTo(jID.resource);
        }
        return n;
    }

    public static boolean equals(String string, String string2) {
        return new JID(string).equals(new JID(string2));
    }
}

