/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends ASN1Object {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this(true, n, dEREncodable);
    }

    public DERApplicationSpecific(boolean bl, int n, DEREncodable dEREncodable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (n >= 31) {
            throw new IOException("unsupported tag number");
        }
        if (bl) {
            this.tag = n | 0x20;
            this.octets = byArray;
        } else {
            this.tag = n;
            int n2 = this.getLengthOfLength(byArray);
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    private int getLengthOfLength(byte[] byArray) {
        int n = 2;
        while ((byArray[n - 1] & 0x80) != 0) {
            ++n;
        }
        return n;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int n) throws IOException {
        if (this.tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byArray[0] = (byte)n;
        return new ASN1InputStream(byArray).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        if (this.tag != dERApplicationSpecific.tag) {
            return false;
        }
        if (this.octets.length != dERApplicationSpecific.octets.length) {
            return false;
        }
        for (int i = 0; i < this.octets.length; ++i) {
            if (this.octets[i] == dERApplicationSpecific.octets[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.getContents();
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n ^= (byArray[i] & 0xFF) << i % 4;
        }
        return n ^ this.getApplicationTag();
    }
}

