/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class PrivacyItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final int MODE_ALLOW_ALL = 1;
    public static final int MODE_BLOCK_ALL = 2;
    public static final int MODE_ALLOW_PERMITS = 3;
    public static final int MODE_BLOCK_DENIES = 4;
    public static final int MODE_ALLOW_BUDDIES = 5;
    public static final long VISMASK_HIDE_WIRELESS = 2L;
    private static final String NAME_DEFAULT = "";
    private static final int PARENTID_DEFAULT = 0;
    private static final int TYPE_PRIVACY_MODE = 202;
    private static final int TYPE_CLASS_MASK = 203;
    private static final int TYPE_VISIBLE_MASK = 204;
    private final int id;
    private int privacyMode;
    private long classMask;
    private long visibleMask;

    public PrivacyItem(SsiItem ssiItem) {
        DefensiveTools.checkNull(ssiItem, "item");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        this.id = ssiItem.getId();
        Tlv tlv = immutableTlvChain.getLastTlv(202);
        this.privacyMode = tlv != null ? (int)BinaryTools.getUByte(tlv.getData(), 0) : -1;
        Tlv tlv2 = immutableTlvChain.getLastTlv(203);
        this.classMask = tlv2 != null ? BinaryTools.getUInt(tlv2.getData(), 0) : -1L;
        Tlv tlv3 = immutableTlvChain.getLastTlv(204);
        this.visibleMask = tlv3 != null ? BinaryTools.getUInt(tlv3.getData(), 0) : -1L;
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
        mutableTlvChain.removeTlvs(202, 203, 204);
        this.addExtraTlvs(mutableTlvChain);
    }

    public PrivacyItem(PrivacyItem privacyItem) {
        this(privacyItem.id, privacyItem.privacyMode, privacyItem.classMask, privacyItem.visibleMask, privacyItem.copyExtraTlvs());
    }

    public PrivacyItem(int n, int n2, long l) {
        this(n, n2, 0xFFFFFFFFL, l);
    }

    public PrivacyItem(int n, int n2, long l, long l2) {
        this(n, n2, l, l2, null);
    }

    public PrivacyItem(int n, int n2, long l, long l2, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkRange(n, "id", 0);
        DefensiveTools.checkRange(n2, "mode", -1);
        DefensiveTools.checkRange(l, "classMask", -1L);
        DefensiveTools.checkRange(l2, "visibleMask", -1L);
        this.id = n;
        this.privacyMode = n2;
        this.classMask = l;
        this.visibleMask = l2;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized int getPrivacyMode() {
        return this.privacyMode;
    }

    public final synchronized long getClassMask() {
        return this.classMask;
    }

    public final synchronized long getVisibleMask() {
        return this.visibleMask;
    }

    public final synchronized void setPrivacyMode(int n) {
        this.privacyMode = n;
    }

    public final synchronized void setClassMask(long l) {
        this.classMask = l;
    }

    public final synchronized void setVisibleMask(long l) {
        this.visibleMask = l;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.privacyMode != -1) {
            mutableTlvChain.addTlv(new Tlv(202, ByteBlock.wrap(BinaryTools.getUByte(this.privacyMode))));
        }
        if (this.classMask != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(203, this.classMask));
        }
        if (this.visibleMask != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(204, this.visibleMask));
        }
        return this.generateItem(NAME_DEFAULT, 0, this.id, 4, mutableTlvChain);
    }

    public synchronized String toString() {
        return "PrivacyItem: id=0x" + Integer.toHexString(this.id) + ", mode=" + this.privacyMode + " (" + MiscTools.findIntField(PrivacyItem.class, this.privacyMode, "MODE_.*") + ")" + ", classMask=0x" + Long.toHexString(this.classMask) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.classMask, "VISMASK_.*") + ")" + ", visMask=0x" + Long.toHexString(this.visibleMask) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.visibleMask, "MASK_.*") + ")";
    }
}

