/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetInterestsCmd
extends LocCommand {
    private static final int TYPE_CHARSET = 28;
    private static final int TYPE_INTEREST = 11;
    private final List<String> interests;

    protected SetInterestsCmd(SnacPacket snacPacket) {
        super(15);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        String string = immutableTlvChain.getString(28);
        List<Tlv> list = immutableTlvChain.getTlvs(11);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Tlv tlv : list) {
            ByteBlock byteBlock2 = tlv.getData();
            String string2 = OscarTools.getString(byteBlock2, string);
            arrayList.add(string2);
        }
        this.interests = Collections.unmodifiableList(arrayList);
    }

    public SetInterestsCmd(List<String> list) {
        super(15);
        this.interests = DefensiveTools.getUnmodifiableCopy(list);
    }

    public final List<String> getInterests() {
        return this.interests;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.interests == null || this.interests.isEmpty()) {
            return;
        }
        MinimalEncoder minimalEncoder = new MinimalEncoder();
        minimalEncoder.updateAll(this.interests);
        Tlv.getStringInstance(28, minimalEncoder.getCharset()).write(outputStream);
        for (String string : this.interests) {
            byte[] byArray = minimalEncoder.encode(string).getData();
            new Tlv(11, ByteBlock.wrap(byArray)).write(outputStream);
        }
    }

    public String toString() {
        return "SetInterestsCmd: interests=" + this.interests;
    }
}

