/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.ChatCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UsersCmd
extends ChatCommand {
    private final List<FullUserInfo> users;

    protected UsersCmd(int n, SnacPacket snacPacket) {
        super(n);
        FullUserInfo fullUserInfo;
        DefensiveTools.checkNull(snacPacket, "packet");
        ArrayList<FullUserInfo> arrayList = new ArrayList<FullUserInfo>();
        ByteBlock byteBlock = snacPacket.getData();
        while ((fullUserInfo = FullUserInfo.readUserInfo(byteBlock)) != null) {
            arrayList.add(fullUserInfo);
            byteBlock = byteBlock.subBlock(fullUserInfo.getTotalSize());
        }
        this.users = DefensiveTools.getUnmodifiable(arrayList);
    }

    protected UsersCmd(int n, Collection<FullUserInfo> collection) {
        super(n);
        this.users = DefensiveTools.getSafeNonnullListCopy(collection, "users");
    }

    public final List<FullUserInfo> getUsers() {
        return this.users;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.users != null) {
            for (FullUserInfo fullUserInfo : this.users) {
                fullUserInfo.write(outputStream);
            }
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + " for " + this.users.size() + " users";
    }
}

