/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.getfile;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFileEntry
implements LiveWritable {
    public static final long FLAG_DIR = 1L;
    private static final int TYPE_LASTMOD = 257;
    private static final int TYPE_FILESIZE = 771;
    private static final int TYPE_FILENAME = 1028;
    private static final int TYPE_FLAGS = 2304;
    private static final int TYPE_SENTINEL = 2313;
    private final SegmentedFilename filename;
    private final long filesize;
    private final long lastmod;
    private final long flags;
    private final int totalTlvCount;

    @Nullable
    public static GetFileEntry readEntry(List<Tlv> list, int n) {
        Writable writable;
        int n2;
        DefensiveTools.checkNull(list, "tlvs");
        DefensiveTools.checkRange(n, "offset", 0, list.size() - 1);
        boolean bl = false;
        int n3 = -1;
        for (n2 = n; n2 < list.size(); ++n2) {
            writable = list.get(n2);
            DefensiveTools.checkNull(writable, "tlvs elements");
            int n4 = ((Tlv)writable).getType();
            if (n4 == 257) {
                if (!bl) {
                    bl = true;
                    continue;
                }
                n3 = n2 - 1;
                break;
            }
            if (n4 != 2313) continue;
            n3 = n2;
            break;
        }
        if ((n2 = n3 == -1 ? list.size() - n : n3 - n + 1) == 0) {
            return null;
        }
        writable = TlvTools.createChain(list, n, n2);
        SegmentedFilename segmentedFilename = null;
        String string = writable.getString(1028);
        if (string != null) {
            segmentedFilename = SegmentedFilename.fromFTFilename(string);
        }
        Tlv tlv = writable.getFirstTlv(257);
        long l = -1L;
        if (tlv != null) {
            l = tlv.getDataAsUInt();
        }
        Tlv tlv2 = writable.getFirstTlv(771);
        long l2 = -1L;
        if (tlv2 != null) {
            l2 = tlv2.getDataAsUInt();
        }
        Tlv tlv3 = writable.getFirstTlv(2304);
        long l3 = 0L;
        if (tlv3 != null && (l3 = tlv3.getDataAsUInt()) == -1L) {
            l3 = 0L;
        }
        return new GetFileEntry(segmentedFilename, l2, l, l3, n2);
    }

    private GetFileEntry(SegmentedFilename segmentedFilename, long l, long l2, long l3, int n) {
        this.filename = segmentedFilename;
        this.filesize = l;
        this.lastmod = l2;
        this.flags = l3;
        this.totalTlvCount = n;
    }

    public GetFileEntry(File file) {
        this(SegmentedFilename.fromNativeFilename(file.getName()), file);
    }

    public GetFileEntry(SegmentedFilename segmentedFilename, File file) {
        this(segmentedFilename, file.length(), file.lastModified() / 1000L, file.isDirectory() ? 1L : 0L);
    }

    public GetFileEntry(SegmentedFilename segmentedFilename, long l, long l2, long l3) {
        DefensiveTools.checkRange(l2, "lastmod", -1L);
        DefensiveTools.checkRange(l, "filesize", -1L);
        DefensiveTools.checkRange(l3, "flags", -1L);
        long l4 = l3 == -1L ? 0L : l3;
        this.lastmod = l2;
        this.filesize = l;
        this.filename = segmentedFilename;
        this.flags = l4;
        this.totalTlvCount = -1;
    }

    public final SegmentedFilename getFilename() {
        return this.filename;
    }

    public final long getFileSize() {
        return this.filesize;
    }

    public final long getLastmod() {
        return this.lastmod;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getTotalTlvCount() {
        return this.totalTlvCount;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.lastmod != -1L) {
            Tlv.getUIntInstance(257, this.lastmod).write(outputStream);
        }
        if (this.filesize != -1L) {
            Tlv.getUIntInstance(771, this.filesize).write(outputStream);
        }
        Tlv.getUShortInstance(1285, 0).write(outputStream);
        if (this.filename != null) {
            String string = this.filename.toFTFilename();
            Tlv.getStringInstance(1028, string).write(outputStream);
        }
        if (this.flags != 0L) {
            Tlv.getUIntInstance(2304, this.flags).write(outputStream);
        }
        new Tlv(2313).write(outputStream);
    }

    public String toString() {
        return "GetFileEntry: file=<" + this.filename + ">, " + (float)this.filesize / 1024.0f + " KB, last modified " + new Date(this.lastmod * 1000L) + " (flags=" + this.flags + " - " + MiscTools.getFlagFieldsString(GetFileEntry.class, this.flags, "FLAG_.*") + ")";
    }
}

