/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.io.InputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.InvalidFlapHeaderException;
import org.jetbrains.annotations.Nullable;

final class FlapHeader {
    private static final int PARITY_BYTE = 42;
    private final int seqnum;
    private final int channel;
    private final int length;

    @Nullable
    public static FlapHeader readFLAPHeader(InputStream inputStream) throws InvalidFlapHeaderException, IOException {
        DefensiveTools.checkNull(inputStream, "in");
        byte[] byArray = new byte[6];
        int n = 0;
        boolean bl = false;
        while (n < byArray.length) {
            int n2 = inputStream.read(byArray, n, byArray.length - n);
            if (n2 == -1) {
                return null;
            }
            if (bl || (n += n2) < 1) continue;
            bl = true;
            if (byArray[0] == 42) continue;
            throw new InvalidFlapHeaderException("first byte of FLAP header must be 0x" + Integer.toHexString(42) + ", was 0x" + Integer.toHexString(byArray[0]));
        }
        return new FlapHeader(ByteBlock.wrap(byArray));
    }

    FlapHeader(ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(byteBlock, "bytes");
        if (byteBlock.getLength() != 6) {
            throw new IllegalArgumentException("FLAP header length (" + byteBlock.getLength() + ") must be 6");
        }
        if (byteBlock.get(0) != 42) {
            throw new IllegalArgumentException("FLAP command must begin with 0x2a (started with 0x" + Integer.toHexString(byteBlock.get(0) & 0xFF) + "): " + BinaryTools.describeData(byteBlock.subBlock(0, 6)) + " (data: " + (byteBlock.getLength() - 6) + " bytes)");
        }
        this.channel = BinaryTools.getUByte(byteBlock, 1);
        this.seqnum = BinaryTools.getUShort(byteBlock, 2);
        this.length = BinaryTools.getUShort(byteBlock, 4);
    }

    public final int getSeqnum() {
        return this.seqnum;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final int getDataLength() {
        return this.length;
    }

    public String toString() {
        return "FlapHeader: seqnum=" + this.seqnum + ", channel=" + this.channel + ", length=" + this.length;
    }
}

