/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class GroupItem
extends AbstractItemObj {
    private static final int ID_DEFAULT = 0;
    private static final int TYPE_BUDDIES = 200;
    private String name;
    private final int id;
    private int[] buddies;

    public GroupItem(SsiItem ssiItem) {
        Writable writable;
        DefensiveTools.checkNull(ssiItem, "item");
        this.name = ssiItem.getName();
        this.id = ssiItem.getParentId();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        Tlv tlv = immutableTlvChain.getLastTlv(200);
        if (tlv != null) {
            writable = tlv.getData();
            this.buddies = new int[((ByteBlock)writable).getLength() / 2];
            for (int i = 0; i < this.buddies.length; ++i) {
                this.buddies[i] = BinaryTools.getUShort((ByteBlock)writable, i * 2);
            }
        } else {
            this.buddies = null;
        }
        writable = TlvTools.getMutableCopy(immutableTlvChain);
        writable.removeTlvs(200);
        this.addExtraTlvs((TlvChain)writable);
    }

    public GroupItem(GroupItem groupItem) {
        this(groupItem.name, groupItem.id, groupItem.buddies == null ? null : (int[])groupItem.buddies.clone(), groupItem.copyExtraTlvs());
    }

    public GroupItem(String string, int n) {
        this(string, n, null, null);
    }

    public GroupItem(String string, int n, int[] nArray) {
        this(string, n, nArray, null);
    }

    public GroupItem(String string, int n, int[] nArray, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkNull(string, "name");
        DefensiveTools.checkRange(n, "id", 0);
        this.name = string;
        this.id = n;
        this.buddies = nArray == null ? null : (int[])nArray.clone();
    }

    public final String getGroupName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final synchronized int[] getBuddies() {
        return this.buddies == null ? null : (int[])this.buddies.clone();
    }

    public final synchronized void setBuddies(@Nullable int[] nArray) {
        this.buddies = DefensiveTools.getSafeMinArrayCopy(nArray, "buddies", 0);
    }

    public void setGroupName(String string) {
        this.name = string;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.buddies != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.buddies.length * 2);
            try {
                for (int n : this.buddies) {
                    BinaryTools.writeUShort(byteArrayOutputStream, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ByteBlock byteBlock = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
            mutableTlvChain.addTlv(new Tlv(200, byteBlock));
        }
        return this.generateItem(this.name, this.id, 0, 1, mutableTlvChain);
    }

    public synchronized String toString() {
        String string;
        if (this.buddies != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int n : this.buddies) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(n));
                stringBuffer.append(", ");
            }
            string = stringBuffer.toString();
        } else {
            string = "none";
        }
        return "GroupItem for " + this.name + ", groupid=0x" + Integer.toHexString(this.id) + ", buddies: " + string;
    }
}

