/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.conn.ClientReadyCmd;
import net.kano.joscar.snaccmd.conn.ClientVersionsCmd;
import net.kano.joscar.snaccmd.conn.MyInfoRequest;
import net.kano.joscar.snaccmd.conn.Noop;
import net.kano.joscar.snaccmd.conn.PauseAck;
import net.kano.joscar.snaccmd.conn.RateAck;
import net.kano.joscar.snaccmd.conn.RateInfoRequest;
import net.kano.joscar.snaccmd.conn.ServiceRequest;
import net.kano.joscar.snaccmd.conn.SetEncryptionInfoCmd;
import net.kano.joscar.snaccmd.conn.SetExtraInfoCmd;
import net.kano.joscar.snaccmd.conn.SetIdleCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(1, 23), new CmdType(1, 6), new CmdType(1, 8), new CmdType(1, 14), new CmdType(1, 2), new CmdType(1, 22), new CmdType(1, 4), new CmdType(1, 12), new CmdType(1, 17), new CmdType(1, 30), new CmdType(1, 34));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 1) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 23) {
            return new ClientVersionsCmd(snacPacket);
        }
        if (n == 6) {
            return new RateInfoRequest(snacPacket);
        }
        if (n == 8) {
            return new RateAck(snacPacket);
        }
        if (n == 14) {
            return new MyInfoRequest(snacPacket);
        }
        if (n == 2) {
            return new ClientReadyCmd(snacPacket);
        }
        if (n == 22) {
            return new Noop(snacPacket);
        }
        if (n == 4) {
            return new ServiceRequest(snacPacket);
        }
        if (n == 12) {
            return new PauseAck(snacPacket);
        }
        if (n == 17) {
            return new SetIdleCmd(snacPacket);
        }
        if (n == 30) {
            return new SetExtraInfoCmd(snacPacket);
        }
        if (n == 34) {
            return new SetEncryptionInfoCmd(snacPacket);
        }
        return null;
    }
}

