/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ClientConnStreamHandler;
import net.kano.joscar.net.ConnDescriptor;

public class ClientConn {
    public static final State STATE_NOT_CONNECTED = new State("NOT_CONNECTED");
    public static final State STATE_INITING = new State("INITING");
    public static final State STATE_RESOLVING = new State("RESOLVING");
    public static final State STATE_CONNECTING = new State("CONNECTING");
    public static final State STATE_CONNECTED = new State("CONNECTED");
    public static final State STATE_FAILED = new State("FAILED");
    public static final String REASON_ON_PURPOSE = "ON_PURPOSE";
    public static final String REASON_CONN_CLOSED = "CONN_CLOSED";
    private State state = STATE_NOT_CONNECTED;
    private final String host;
    private final InetAddress ip;
    private final int port;
    private CopyOnWriteArrayList<ClientConnListener> connListeners = new CopyOnWriteArrayList();
    private SocketFactory socketFactory = null;
    private Socket socket = null;
    private ConnectionThread connThread = null;
    private ClientConnStreamHandler streamHandler = null;

    public ClientConn(ConnDescriptor connDescriptor) {
        DefensiveTools.checkNull(connDescriptor, "cd");
        this.host = connDescriptor.getHost();
        this.ip = connDescriptor.getAddress();
        this.port = connDescriptor.getPort();
    }

    public final void addConnListener(ClientConnListener clientConnListener) {
        DefensiveTools.checkNull(clientConnListener, "l");
        this.connListeners.addIfAbsent(clientConnListener);
    }

    public final void removeConnListener(ClientConnListener clientConnListener) {
        DefensiveTools.checkNull(clientConnListener, "l");
        this.connListeners.remove(clientConnListener);
    }

    public final synchronized Socket getSocket() {
        return this.socket;
    }

    public final synchronized String getHost() {
        return this.host;
    }

    public final synchronized InetAddress getIpAddress() {
        return this.ip;
    }

    public final synchronized int getPort() {
        return this.port;
    }

    public final synchronized State getState() {
        return this.state;
    }

    private synchronized void setState(State state, Serializable serializable) {
        if (this.state == state || this.state == STATE_FAILED && state == STATE_NOT_CONNECTED) {
            return;
        }
        State state2 = this.state;
        this.state = state;
        ClientConnEvent clientConnEvent = new ClientConnEvent(this, state2, this.state, serializable);
        for (ClientConnListener clientConnListener : this.connListeners) {
            clientConnListener.stateChanged(clientConnEvent);
        }
    }

    private synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public final synchronized void connect() throws IllegalStateException {
        if (this.state != STATE_NOT_CONNECTED && this.state != STATE_FAILED) {
            throw new IllegalStateException("I am already connected/connecting");
        }
        if (this.host == null && this.ip == null) {
            throw new IllegalStateException("either host or ip must be non-null");
        }
        if (this.host != null && this.ip != null) {
            throw new IllegalStateException("host and ip may not both be non-null");
        }
        if (this.port == -1) {
            throw new IllegalStateException("port must not be -1");
        }
        this.setState(STATE_INITING, null);
        Object object = this.host == null ? this.ip : this.host;
        this.connThread = new ConnectionThread(MiscTools.getClassName(this) + " to " + object + ":" + this.port);
        try {
            this.connThread.start();
        }
        catch (Throwable throwable) {
            this.setState(STATE_FAILED, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void processError(IOException iOException) {
        DefensiveTools.checkNull(iOException, "o");
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void disconnect() {
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, (Serializable)((Object)REASON_ON_PURPOSE));
        }
    }

    private synchronized void closeConn() {
        if (this.connThread != null) {
            this.connThread.cancel();
            this.connThread = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final synchronized void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final synchronized SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final synchronized void setStreamHandler(ClientConnStreamHandler clientConnStreamHandler) {
        this.streamHandler = clientConnStreamHandler;
    }

    public final synchronized ClientConnStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    private Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SocketFactory socketFactory = this.getSocketFactory();
        if (socketFactory != null) {
            return socketFactory.createSocket(inetAddress, n);
        }
        return new Socket(inetAddress, n);
    }

    public String toString() {
        return "ClientConn: state=" + this.state + ", socket=" + this.socket;
    }

    public static final class State {
        private final String name;

        private State(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ConnectionThread
    extends Thread {
        private volatile boolean cancelled;

        private ConnectionThread(String string) {
            super(string);
            this.cancelled = false;
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            ClientConn clientConn;
            ClientConn clientConn2 = clientConn = ClientConn.this;
            // MONITORENTER : clientConn2
            InetAddress inetAddress = clientConn.ip;
            String string = clientConn.host;
            // MONITOREXIT : clientConn2
            if (inetAddress == null) {
                clientConn2 = clientConn;
                // MONITORENTER : clientConn2
                if (this.cancelled) {
                    // MONITOREXIT : clientConn2
                    return;
                }
                ClientConn.this.setState(STATE_RESOLVING, null);
                // MONITOREXIT : clientConn2
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    ClientConn clientConn3 = clientConn;
                    // MONITORENTER : clientConn3
                    if (this.cancelled) {
                        // MONITOREXIT : clientConn3
                        return;
                    }
                    ClientConn.this.setState(STATE_FAILED, unknownHostException);
                    // MONITOREXIT : clientConn3
                    return;
                }
            }
            Object object = clientConn;
            // MONITORENTER : object
            if (this.cancelled) {
                // MONITOREXIT : object
                return;
            }
            ClientConn.this.setState(STATE_CONNECTING, null);
            int n = clientConn.port;
            // MONITOREXIT : object
            try {
                object = ClientConn.this.createSocket(inetAddress, n);
            }
            catch (IOException iOException) {
                ClientConn clientConn4 = clientConn;
                // MONITORENTER : clientConn4
                if (this.cancelled) {
                    // MONITOREXIT : clientConn4
                    return;
                }
                ClientConn.this.setState(STATE_FAILED, iOException);
                // MONITOREXIT : clientConn4
                return;
            }
            ClientConn clientConn5 = clientConn;
            // MONITORENTER : clientConn5
            if (this.cancelled) {
                // MONITOREXIT : clientConn5
                return;
            }
            ClientConn.this.setSocket((Socket)object);
            ClientConn.this.setState(STATE_CONNECTED, null);
            // MONITOREXIT : clientConn5
            try {
                clientConn5 = clientConn;
                // MONITORENTER : clientConn5
                if (this.cancelled) {
                    // MONITOREXIT : clientConn5
                    return;
                }
                // MONITOREXIT : clientConn5
                ClientConn.this.getStreamHandler().handleStream(ClientConn.this, (Socket)object);
                return;
            }
            catch (IOException iOException) {
                ClientConn clientConn6 = clientConn;
                // MONITORENTER : clientConn6
                if (this.cancelled) {
                    // MONITOREXIT : clientConn6
                    return;
                }
                ClientConn.this.processError(iOException);
                // MONITOREXIT : clientConn6
                return;
            }
            finally {
                ClientConn clientConn7 = clientConn;
            }
        }

        public String toString() {
            return "ClientConn.ConnectionThread for " + ClientConn.this;
        }
    }
}

