/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.rvproto.directim.DirectImHeader;
import net.kano.joustsim.oscar.oscar.service.icbm.DirectMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Attachment;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.BuddyTypingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Cancellable;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimQueueProcessor;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimReceiver;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DoneReceivingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractStateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PausableController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PauseHelper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PauseHelperImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TimeoutableController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import org.jetbrains.annotations.Nullable;

public class DirectimController
extends AbstractStateController
implements PausableController,
Cancellable,
TimeoutableController,
ConnectedController {
    private static final Logger LOGGER = Logger.getLogger(DirectimController.class.getName());
    private DirectimConnection connection;
    private StreamInfo stream;
    private Thread recvThread;
    private Thread sendThread;
    private volatile boolean cancelled = false;
    private PauseHelper pauseHelper = new PauseHelperImpl();
    private final List<Object> queue = new ArrayList<Object>();
    private DirectimQueueProcessor queueProcessor = null;
    private final Object icbmIdLock = new Object();
    private boolean icbmIdConfirmed = false;

    public void start(RvConnection conn, StateController last) {
        this.connection = (DirectimConnection)conn;
        if (this.connection.getRvSessionInfo().getInitiator() == Initiator.BUDDY) {
            this.setIcbmIdConfirmed();
        }
        this.stream = (StreamInfo)((Object)last.getEndStateInfo());
        this.connection.getTimeoutHandler().startTimeout(this);
        this.queueProcessor = new DirectimQueueProcessor(this, this.connection, this.stream);
        this.recvThread = new Thread(new Runnable(){

            public void run() {
                try {
                    DirectimController.this.receiveInThread();
                }
                catch (Exception e) {
                    DirectimController.this.fireFailed(e);
                }
            }
        }, "Direct IM reader");
        this.recvThread.setDaemon(true);
        this.recvThread.start();
        this.queue.add(DirectimQueueProcessor.INIT);
        this.sendThread = new Thread((Runnable)new DimQueue(), "Direct IM queue");
        this.sendThread.setDaemon(true);
        this.sendThread.start();
    }

    @Nullable
    public ConnectionType getTimeoutType() {
        return null;
    }

    public void cancelIfNotFruitful(long timeout) {
        if (!this.isIcbmIdConfirmed()) {
            this.fireFailed(new ConnectionTimedOutEvent(timeout));
        }
    }

    public boolean isConnected() {
        return this.isIcbmIdConfirmed();
    }

    public boolean didConnect() {
        return this.isConnected();
    }

    public void pauseTransfer() {
        this.pauseHelper.setPaused(true);
    }

    public void unpauseTransfer() {
        this.pauseHelper.setPaused(false);
    }

    private void receiveInThread() throws IOException {
        this.connection.getEventPost().fireEvent(new ConnectedEvent());
        InputStream is = this.stream.getInputStream();
        while (true) {
            DirectimReceiver receiver;
            long transferred;
            DirectImHeader header;
            if ((header = DirectImHeader.readDirectIMHeader((InputStream)is)) == null) {
                this.fireFailed(new UnknownErrorEvent());
                break;
            }
            long datalen = header.getDataLength();
            long flags = header.getFlags();
            EventPost eventPost = this.connection.getEventPost();
            if ((flags & 2L) != 0L) {
                eventPost.fireEvent(new BuddyTypingEvent(DirectimController.getTypingState(flags)));
            }
            RvSessionConnectionInfo rvinfo = this.connection.getRvSessionInfo();
            if (!this.isIcbmIdConfirmed() && rvinfo.getInitiator() == Initiator.ME) {
                long realid = rvinfo.getRvSession().getRvSessionId();
                if ((flags & 0x20L) != 0L && header.getMessageId() == realid) {
                    this.setIcbmIdConfirmed();
                } else {
                    LOGGER.warning("Buddy sent wrong confirmation ICBM ID: " + header.getMessageId() + " should be " + realid);
                    this.fireFailed(new UnknownErrorEvent());
                    return;
                }
            }
            if (datalen <= 0L) continue;
            LOGGER.fine("Read header; reading packet of " + datalen + " bytes");
            String charset = header.getEncoding().toCharsetName();
            if (charset == null) {
                charset = "US-ASCII";
            }
            if ((transferred = (receiver = new DirectimReceiver(this.stream, eventPost, this.getPauseHelper(), this.connection.getAttachmentSaver(), this, charset, datalen, DirectimReceiver.isAutoResponse(header))).transfer()) != datalen) {
                LOGGER.info("Position at end was " + transferred + ", expected " + datalen);
                this.fireFailed(new UnknownErrorEvent());
                break;
            }
            eventPost.fireEvent(new DoneReceivingEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIcbmIdConfirmed() {
        Object object = this.icbmIdLock;
        synchronized (object) {
            if (this.icbmIdConfirmed) {
                return;
            }
            this.icbmIdConfirmed = true;
            this.icbmIdLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIcbmIdConfirmed() {
        Object object = this.icbmIdLock;
        synchronized (object) {
            return this.icbmIdConfirmed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForIcbmIdConfirmation() {
        Object object = this.icbmIdLock;
        synchronized (object) {
            while (!this.icbmIdConfirmed) {
                try {
                    this.icbmIdLock.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return this.icbmIdConfirmed;
        }
    }

    private static TypingState getTypingState(long flags) {
        TypingState state = (flags & 4L) != 0L ? TypingState.PAUSED : ((flags & 8L) != 0L ? TypingState.TYPING : TypingState.NO_TEXT);
        return state;
    }

    public void setTypingState(TypingState state) {
        this.enqueue((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Object o) {
        List<Object> list = this.queue;
        synchronized (list) {
            this.queue.add(o);
            this.queue.notifyAll();
        }
    }

    public void sendMessage(Message message) {
        if (message instanceof DirectMessage) {
            DirectMessage dim = (DirectMessage)message;
            for (Attachment attachment : dim.getAttachments()) {
                if (!attachment.getId().matches(".*(\"|<|>).*")) continue;
                throw new IllegalArgumentException("Attachment ID " + attachment + " is invalid: illegal character \"<>");
            }
        }
        this.enqueue(message);
    }

    public void stop() {
        LOGGER.info("Stopping directim controller");
        this.cancelled = true;
        if (this.recvThread != null) {
            this.recvThread.interrupt();
        }
        if (this.sendThread != null) {
            this.sendThread.interrupt();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public PauseHelper getPauseHelper() {
        return this.pauseHelper;
    }

    private class DimQueue
    implements Runnable {
        private DimQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (true) {
                ArrayList newItems;
                if (!DirectimController.this.waitForIcbmIdConfirmation()) {
                    return;
                }
                List list = DirectimController.this.queue;
                synchronized (list) {
                    if (DirectimController.this.queue.isEmpty()) {
                        try {
                            DirectimController.this.queue.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    newItems = new ArrayList(DirectimController.this.queue);
                    DirectimController.this.queue.clear();
                }
                Iterator i$ = newItems.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block8;
                    Object item = i$.next();
                    try {
                        DirectimController.this.queueProcessor.processItem(item);
                    }
                    catch (IOException e) {
                        DirectimController.this.fireFailed(e);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while processing DIM queue", e);
                    }
                }
                break;
            }
        }

        protected void processItem(Object item) throws IOException {
            DirectimController.this.queueProcessor.processItem(item);
        }
    }
}

