/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.StreamChannelSession;

public class SocketSession
extends StreamChannelSession {
    private SocketAddress socketAddress;
    private SocketChannel channel;
    private SelectionKey selectionKey;

    public void setSocketAddress(SocketAddress socketAddress) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set socket address after session started");
        }
        this.socketAddress = socketAddress;
    }

    public void setChannel(SocketChannel socketChannel) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set socket channel after session started");
        }
        this.channel = socketChannel;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            return;
        }
        if (this.socketAddress == null && this.channel == null) {
            throw new IllegalStateException("must specify socket address or socket channel before start");
        }
        if (this.channel == null) {
            try {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                this.channel.connect(this.socketAddress);
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.channel = null;
                }
                this.dispatchSessionClosed();
                return;
            }
        }
        this.startSession(this.channel, this.channel, bl);
    }

    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isConnected();
    }

    public void onEvent(Object object, Object object2) {
        if (object == Constants.EV_CONNECTABLE) {
            this.onConnectable();
        }
        super.onEvent(object, object2);
    }

    protected void onConnectable() {
        try {
            this.channel.finishConnect();
            this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFF7 | 1);
            this.dispatchSessionEstablished();
        }
        catch (ConnectException connectException) {
            this.close();
        }
        catch (IOException iOException) {
            this.dispatchException(iOException);
            this.close();
        }
    }

    protected void onRegister(Selector selector) {
        try {
            if (this.isConnected()) {
                this.selectionKey = this.channel.register(selector, 1, this);
                super.onRegister(selector);
                this.dispatchSessionEstablished();
            } else {
                this.selectionKey = this.channel.register(selector, 8, this);
                super.onRegister(selector);
            }
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
    }

    protected void onUnregister() {
        this.channel = null;
        this.selectionKey = null;
        super.onUnregister();
    }
}

