/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.StringTokenizer;
import gov.nist.core.Token;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;

public class LexerCore
extends StringTokenizer {
    public static final int START = 2048;
    public static final int END = 4096;
    public static final int ID = 4095;
    public static final int SAFE = 4094;
    public static final int WHITESPACE = 4097;
    public static final int DIGIT = 4098;
    public static final int ALPHA = 4099;
    public static final int BACKSLASH = 92;
    public static final int QUOTE = 39;
    public static final int AT = 64;
    public static final int SP = 32;
    public static final int HT = 9;
    public static final int COLON = 58;
    public static final int STAR = 42;
    public static final int DOLLAR = 36;
    public static final int PLUS = 43;
    public static final int POUND = 35;
    public static final int MINUS = 45;
    public static final int DOUBLEQUOTE = 34;
    public static final int TILDE = 126;
    public static final int BACK_QUOTE = 96;
    public static final int NULL = 0;
    public static final int EQUALS = 61;
    public static final int SEMICOLON = 59;
    public static final int SLASH = 47;
    public static final int L_SQUARE_BRACKET = 91;
    public static final int R_SQUARE_BRACKET = 93;
    public static final int R_CURLY = 125;
    public static final int L_CURLY = 123;
    public static final int HAT = 94;
    public static final int BAR = 124;
    public static final int DOT = 46;
    public static final int EXCLAMATION = 33;
    public static final int LPAREN = 40;
    public static final int RPAREN = 41;
    public static final int GREATER_THAN = 62;
    public static final int LESS_THAN = 60;
    public static final int PERCENT = 37;
    public static final int QUESTION = 63;
    public static final int AND = 38;
    public static final int UNDERSCORE = 95;
    protected static Hashtable globalSymbolTable = new Hashtable();
    protected static Hashtable lexerTables = new Hashtable();
    protected Hashtable currentLexer;
    protected String currentLexerName;
    protected Token currentMatch;

    protected void addKeyword(String string, int n) {
        Integer n2 = new Integer(n);
        this.currentLexer.put(string, n2);
        if (!globalSymbolTable.containsKey(n2)) {
            globalSymbolTable.put(n2, string);
        }
    }

    public String lookupToken(int n) {
        if (n > 2048) {
            return (String)globalSymbolTable.get(new Integer(n));
        }
        Character c = new Character((char)n);
        return c.toString();
    }

    protected Hashtable addLexer(String string) {
        this.currentLexer = (Hashtable)lexerTables.get(string);
        if (this.currentLexer == null) {
            this.currentLexer = new Hashtable();
            lexerTables.put(string, this.currentLexer);
        }
        return this.currentLexer;
    }

    public void selectLexer(String string) {
        this.currentLexerName = string;
    }

    protected LexerCore() {
        this.currentLexer = new Hashtable();
        this.currentLexerName = "charLexer";
    }

    public LexerCore(String string, String string2) {
        super(string2);
        this.currentLexerName = string;
    }

    public String peekNextId() {
        int n = this.ptr;
        String string = this.ttoken();
        this.savedPtr = this.ptr;
        this.ptr = n;
        return string;
    }

    public String getNextId() {
        return this.ttoken();
    }

    public Token getNextToken() {
        return this.currentMatch;
    }

    public Token peekNextToken() throws ParseException {
        return (Token)this.peekNextToken(1).elementAt(0);
    }

    public Vector peekNextToken(int n) throws ParseException {
        int n2 = this.ptr;
        Vector<Token> vector = new Vector<Token>();
        for (int i = 0; i < n; ++i) {
            Token token = new Token();
            if (this.startsId()) {
                String string;
                token.tokenValue = string = this.ttoken();
                if (this.currentLexer.containsKey(string.toUpperCase())) {
                    Integer n3 = (Integer)this.currentLexer.get(string.toUpperCase());
                    token.tokenType = n3;
                } else {
                    token.tokenType = 4095;
                }
            } else {
                char c = this.getNextChar();
                token.tokenValue = String.valueOf(c);
                token.tokenType = LexerCore.isAlpha(c) ? 4099 : (LexerCore.isDigit(c) ? 4098 : (int)c);
            }
            vector.addElement(token);
        }
        this.savedPtr = this.ptr;
        this.ptr = n2;
        return vector;
    }

    public Token match(int n) throws ParseException {
        if (n > 2048 && n < 4096) {
            if (n == 4095) {
                if (!this.startsId()) {
                    throw new ParseException(this.buffer + "\nID expected", this.ptr);
                }
                String string = this.getNextId();
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = string;
                this.currentMatch.tokenType = 4095;
            } else if (n == 4094) {
                if (!this.startsSafeToken()) {
                    throw new ParseException(this.buffer + "\nID expected", this.ptr);
                }
                String string = this.ttokenSafe();
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = string;
                this.currentMatch.tokenType = 4094;
            } else {
                String string = this.getNextId();
                Integer n2 = (Integer)this.currentLexer.get(string.toUpperCase());
                if (n2 == null || n2 != n) {
                    throw new ParseException(this.buffer + "\nUnexpected Token : " + string, this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = string;
                this.currentMatch.tokenType = n;
            }
        } else if (n > 4096) {
            char c = this.lookAhead(0);
            if (n == 4098) {
                if (!LexerCore.isDigit(c)) {
                    throw new ParseException(this.buffer + "\nExpecting DIGIT", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = String.valueOf(c);
                this.currentMatch.tokenType = n;
                this.consume(1);
            } else if (n == 4099) {
                if (!LexerCore.isAlpha(c)) {
                    throw new ParseException(this.buffer + "\nExpecting ALPHA", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = String.valueOf(c);
                this.currentMatch.tokenType = n;
                this.consume(1);
            }
        } else {
            Character c = new Character((char)n);
            char c2 = this.lookAhead(0);
            if (c2 == c.charValue()) {
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = String.valueOf(c.charValue());
                this.currentMatch.tokenType = n;
                this.consume(1);
            } else {
                throw new ParseException(this.buffer + "\nExpecting  >>>" + c.charValue() + "<<< got >>>" + c2 + "<<<", this.ptr);
            }
        }
        return this.currentMatch;
    }

    public void SPorHT() {
        try {
            while (this.lookAhead(0) == ' ' || this.lookAhead(0) == '\t') {
                this.consume(1);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean startsId() {
        try {
            char c = this.lookAhead(0);
            return LexerCore.isAlpha(c) || LexerCore.isDigit(c) || c == '_' || c == '+' || c == '-' || c == '!' || c == '`' || c == '\'' || c == '~' || c == '%' || c == '.' || c == '*';
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public boolean startsSafeToken() {
        try {
            char c = this.lookAhead(0);
            return LexerCore.isAlpha(c) || LexerCore.isDigit(c) || c == '_' || c == '+' || c == '-' || c == '!' || c == '`' || c == '\'' || c == '~' || c == '.' || c == '/' || c == '}' || c == '{' || c == ']' || c == '[' || c == '^' || c == '|' || c == '~' || c == '#' || c == '@' || c == '$' || c == ':' || c == ';' || c == '?' || c == '\"' || c == '*';
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public String ttoken() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while (this.hasMoreChars() && (LexerCore.isAlpha(c = this.lookAhead(0)) || LexerCore.isDigit(c) || c == '_' || c == '+' || c == '-' || c == '!' || c == '`' || c == '\'' || c == '~' || c == '%' || c == '.' || c == '*')) {
                this.consume(1);
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
    }

    public String ttokenAllowSpace() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while (this.hasMoreChars() && (LexerCore.isAlpha(c = this.lookAhead(0)) || LexerCore.isDigit(c) || c == '_' || c == '+' || c == '-' || c == '!' || c == '`' || c == '\'' || c == '~' || c == '.' || c == ' ' || c == '\t' || c == '*')) {
                stringBuffer.append(c);
                this.consume(1);
            }
            return stringBuffer.toString();
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
    }

    public String ttokenSafe() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while (this.hasMoreChars() && (LexerCore.isAlpha(c = this.lookAhead(0)) || LexerCore.isDigit(c) || c == '_' || c == '+' || c == '-' || c == '!' || c == '`' || c == '\'' || c == '~' || c == '.' || c == '/' || c == '}' || c == '{' || c == ']' || c == '[' || c == '^' || c == '|' || c == '~' || c == '#' || c == '@' || c == '$' || c == ':' || c == ';' || c == '?' || c == '\"' || c == '*')) {
                stringBuffer.append(c);
                this.consume(1);
            }
            return stringBuffer.toString();
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
    }

    public String quotedString() throws ParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lookAhead(0) != '\"') {
            return null;
        }
        this.consume(1);
        while ((c = this.getNextChar()) != '\"') {
            if (c == '\u0000') {
                throw new ParseException(this.buffer + " :unexpected EOL", this.ptr);
            }
            if (c == '\\') {
                stringBuffer.append(c);
                c = this.getNextChar();
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String comment() throws ParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lookAhead(0) != '(') {
            return null;
        }
        this.consume(1);
        while ((c = this.getNextChar()) != ')') {
            if (c == '\u0000') {
                throw new ParseException(this.buffer + " :unexpected EOL", this.ptr);
            }
            if (c == '\\') {
                stringBuffer.append(c);
                c = this.getNextChar();
                if (c == '\u0000') {
                    throw new ParseException(this.buffer + " : unexpected EOL", this.ptr);
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String byteStringNoSemicolon() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while ((c = this.lookAhead(0)) != '\u0000' && c != '\n' && c != ';' && c != ',') {
                this.consume(1);
                stringBuffer.append(c);
            }
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    public String byteStringNoComma() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while ((c = this.lookAhead(0)) != '\n' && c != ',') {
                this.consume(1);
                stringBuffer.append(c);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String charAsString(char c) {
        return new Character(c).toString();
    }

    public String charAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.lookAhead(i));
            }
            return stringBuffer.toString();
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
    }

    public String number() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            if (!LexerCore.isDigit(this.lookAhead(0))) {
                throw new ParseException(this.buffer + ": Unexpected token at " + this.lookAhead(0), this.ptr);
            }
            stringBuffer.append(this.lookAhead(0));
            this.consume(1);
            while (LexerCore.isDigit(c = this.lookAhead(0))) {
                stringBuffer.append(c);
                this.consume(1);
            }
            return stringBuffer.toString();
        }
        catch (ParseException parseException) {
            return stringBuffer.toString();
        }
    }

    public int markInputPosition() {
        return this.ptr;
    }

    public void rewindInputPosition(int n) {
        this.ptr = n;
    }

    public String getRest() {
        if (this.ptr >= this.buffer.length()) {
            return null;
        }
        return this.buffer.substring(this.ptr);
    }

    public String getString(char c) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            if ((c2 = this.lookAhead(0)) == '\u0000') {
                throw new ParseException(this.buffer + "unexpected EOL", this.ptr);
            }
            if (c2 == c) break;
            if (c2 == '\\') {
                this.consume(1);
                char c3 = this.lookAhead(0);
                if (c3 == '\u0000') {
                    throw new ParseException(this.buffer + "unexpected EOL", this.ptr);
                }
                this.consume(1);
                stringBuffer.append(c3);
                continue;
            }
            this.consume(1);
            stringBuffer.append(c2);
        }
        this.consume(1);
        return stringBuffer.toString();
    }

    public int getPtr() {
        return this.ptr;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public ParseException createParseException() {
        return new ParseException(this.buffer, this.ptr);
    }
}

