/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static int __id;
    private transient List _blocked;
    private boolean _daemon;
    private transient int _id;
    private final String _lock = "LOCK";
    private final String _joinLock = "JOIN";
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private int _lowThreads = 25;
    private String _name = "btpool" + __id++;
    int _priority = 5;
    private Set _threads;
    private List _idle;
    private boolean _warned = false;
    private long _lastShrink;

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public boolean isLowOnThreads() {
        return this._maxThreads - this.getThreads() + this.getIdleThreads() < this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        String string = "JOIN";
        synchronized ("JOIN") {
            while (this.isRunning()) {
                "JOIN".wait(this.getMaxIdleTimeMs());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            while (this.isStopping()) {
                Thread.sleep(10L);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        String string = "LOCK";
        synchronized ("LOCK") {
            PoolThread thread = new PoolThread();
            this._threads.add(thread);
            this._idle.add(thread);
            thread.setName(this._name + "-" + this._id++);
            thread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        boolean queued = false;
        String string = "LOCK";
        synchronized ("LOCK") {
            if (!this.isRunning()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            int blockMs = this._maxIdleTimeMs;
            while (this._idle.size() == 0) {
                if (this._threads.size() < this._maxThreads) {
                    this.newThread();
                    break;
                }
                if (!this._warned) {
                    this._warned = true;
                    Log.debug("Out of threads for {}", this);
                }
                if (blockMs < 0) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                try {
                    this._blocked.add(Thread.currentThread());
                    "LOCK".wait(blockMs);
                    blockMs = -1;
                }
                catch (InterruptedException ie) {}
                continue;
                finally {
                    this._blocked.remove(Thread.currentThread());
                }
            }
            PoolThread thread = (PoolThread)this._idle.remove(this._idle.size() - 1);
            thread.dispatch(job);
            queued = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this._idle.size() == 0) {
                Thread.yield();
            }
            return queued;
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        String string = "LOCK";
        synchronized ("LOCK") {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._blocked = new ArrayList();
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < 100; ++i) {
            String string = "LOCK";
            // MONITORENTER : "LOCK"
            Iterator iter = this._threads.iterator();
            while (iter.hasNext()) {
                ((Thread)iter.next()).interrupt();
            }
            // MONITOREXIT : string
            Thread.yield();
            if (this._threads.size() == 0) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        String string = "JOIN";
        // MONITORENTER : "JOIN"
        "JOIN".notifyAll();
        // MONITOREXIT : string
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || job == null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Runnable job = null;
            try {
                while (BoundedThreadPool.this.isRunning()) {
                    block28: {
                        try {
                            Object object = "LOCK";
                            // MONITORENTER : "LOCK"
                            if (job != null) {
                                BoundedThreadPool.this._idle.add(this);
                                if (BoundedThreadPool.this._idle.size() >= BoundedThreadPool.this._minThreads) {
                                    BoundedThreadPool.this._warned = false;
                                }
                                if (BoundedThreadPool.this._blocked.size() > 0) {
                                    ((Thread)BoundedThreadPool.this._blocked.get(0)).interrupt();
                                }
                            }
                            // MONITOREXIT : object
                            object = this;
                            // MONITORENTER : object
                            job = null;
                            if (this._job == null) {
                                this.wait(BoundedThreadPool.this.getMaxIdleTimeMs());
                            }
                            job = this._job;
                            this._job = null;
                            // MONITOREXIT : object
                            if (BoundedThreadPool.this.isRunning() && job != null) {
                                job.run();
                            }
                            object = "LOCK";
                            // MONITORENTER : "LOCK"
                            if (job != null) break block28;
                            long now = System.currentTimeMillis();
                            if (BoundedThreadPool.this._threads.size() <= BoundedThreadPool.this._maxThreads && (BoundedThreadPool.this._idle.size() - BoundedThreadPool.this._blocked.size() <= 0 || BoundedThreadPool.this._threads.size() <= BoundedThreadPool.this._minThreads || now - BoundedThreadPool.this._lastShrink <= (long)BoundedThreadPool.this.getMaxIdleTimeMs())) break block28;
                            BoundedThreadPool.this._lastShrink = now;
                            BoundedThreadPool.this._idle.remove(this);
                            // MONITOREXIT : object
                        }
                        catch (InterruptedException e) {
                            Log.ignore(e);
                            Object var7_6 = null;
                            Object object = "LOCK";
                            // MONITORENTER : "LOCK"
                            BoundedThreadPool.this._idle.remove(this);
                            BoundedThreadPool.this._threads.remove(this);
                            // MONITOREXIT : object
                            object = this;
                            // MONITORENTER : object
                            job = null;
                            job = this._job;
                            // MONITOREXIT : object
                            if (job == null) return;
                            if (!BoundedThreadPool.this.isRunning()) return;
                            BoundedThreadPool.this.dispatch(job);
                            return;
                        }
                        Object var7_5 = null;
                        Object object = "LOCK";
                        // MONITORENTER : "LOCK"
                        BoundedThreadPool.this._idle.remove(this);
                        BoundedThreadPool.this._threads.remove(this);
                        // MONITOREXIT : object
                        object = this;
                        // MONITORENTER : object
                        job = null;
                        job = this._job;
                        // MONITOREXIT : object
                        if (job == null) return;
                        if (!BoundedThreadPool.this.isRunning()) return;
                        BoundedThreadPool.this.dispatch(job);
                        return;
                    }
                    // MONITOREXIT : object
                }
                Object var7_7 = null;
                Object object = "LOCK";
                // MONITORENTER : "LOCK"
                BoundedThreadPool.this._idle.remove(this);
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : object
                object = this;
                // MONITORENTER : object
                job = null;
                job = this._job;
                // MONITOREXIT : object
                if (job == null) return;
                if (!BoundedThreadPool.this.isRunning()) return;
                BoundedThreadPool.this.dispatch(job);
                return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Object object = "LOCK";
                // MONITORENTER : "LOCK"
                BoundedThreadPool.this._idle.remove(this);
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : object
                object = this;
                // MONITORENTER : object
                job = null;
                job = this._job;
                // MONITOREXIT : object
                if (job == null) throw throwable;
                if (!BoundedThreadPool.this.isRunning()) throw throwable;
                BoundedThreadPool.this.dispatch(job);
                throw throwable;
            }
        }
    }
}

