/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.InstallerUtil;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class FSRootChooser
extends JComboBox {
    private File initialParentDirectory;
    private FSRoot lastRoot;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$javax$swing$filechooser$FileSystemView;

    public FSRootChooser(File file) {
        this.initialParentDirectory = file;
        FSRootModel fSRootModel = new FSRootModel();
        this.setModel(fSRootModel);
        this.setRenderer(new FSRootRenderer());
        if (fSRootModel.initialSelection != null) {
            this.setSelectedItem(fSRootModel.initialSelection);
        }
        this.acceptRoot();
    }

    public File getSelectedRoot() {
        return ((FSRoot)this.getSelectedItem()).getFile();
    }

    public void revertToLastRoot() {
        if (this.lastRoot != null) {
            this.setSelectedItem(this.lastRoot);
        }
    }

    public void acceptRoot() {
        this.lastRoot = (FSRoot)this.getSelectedItem();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FSRootRenderer
    extends DefaultListCellRenderer {
        private FSRootRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setIcon(((FSRoot)object).getIcon());
            }
            return this;
        }
    }

    private static class FSRoot {
        private File file;
        private Icon icon;
        private String description;

        public FSRoot(File file, Icon icon, String string) {
            this.file = file;
            this.icon = icon;
            this.description = string;
        }

        public File getFile() {
            return this.file;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }

    private class FSRootModel
    extends DefaultComboBoxModel {
        private Object initialSelection;

        public FSRootModel() {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            File[] fileArray = fileSystemView.getRoots();
            String string = System.getProperty("java.version");
            if (InstallerUtil.isWindows() && !string.startsWith("1.3") && !string.startsWith("1.2")) {
                fileArray = fileSystemView.getFiles(fileArray[0], true);
                fileArray = fileSystemView.getFiles(fileArray[0], true);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.getPath().endsWith(":\\")) continue;
                FSRoot fSRoot = new FSRoot(file, this.getSystemIcon(fileSystemView, file), this.getSystemDisplayName(fileSystemView, file));
                this.addElement(fSRoot);
                if (!FSRootChooser.this.initialParentDirectory.getPath().startsWith(file.getPath())) continue;
                this.initialSelection = fSRoot;
            }
        }

        private Icon getSystemIcon(FileSystemView fileSystemView, File file) {
            try {
                Method method = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FSRootChooser.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getSystemIcon", class$java$io$File == null ? (class$java$io$File = FSRootChooser.class$("java.io.File")) : class$java$io$File);
                return (Icon)method.invoke((Object)fileSystemView, file);
            }
            catch (Exception exception) {
                String string = file.getPath().toLowerCase();
                if (string.startsWith("a:") || string.startsWith("b:")) {
                    return UIManager.getIcon("FileView.hardDriveIcon");
                }
                return UIManager.getIcon("FileView.floppyDriveIcon");
            }
        }

        private String getSystemDisplayName(FileSystemView fileSystemView, File file) {
            try {
                Method method = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FSRootChooser.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getSystemDisplayName", class$java$io$File == null ? (class$java$io$File = FSRootChooser.class$("java.io.File")) : class$java$io$File);
                return (String)method.invoke((Object)fileSystemView, file);
            }
            catch (Exception exception) {
                return file.getPath();
            }
        }
    }
}

