/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.ConnectionConfiguration;

class ServerTrustManager
implements X509TrustManager {
    private static Pattern cnPattern = Pattern.compile("(?i)(cn=)([^,]*)");
    private ConnectionConfiguration configuration;
    private String server;
    private KeyStore trustStore;
    private static Map<KeyStoreOptions, KeyStore> stores = new HashMap<KeyStoreOptions, KeyStore>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTrustManager(String server, ConnectionConfiguration configuration) {
        this.configuration = configuration;
        this.server = server;
        InputStream in = null;
        Map<KeyStoreOptions, KeyStore> map = stores;
        synchronized (map) {
            KeyStoreOptions options = new KeyStoreOptions(configuration.getTruststoreType(), configuration.getTruststorePath(), configuration.getTruststorePassword());
            if (stores.containsKey(options)) {
                this.trustStore = stores.get(options);
            } else {
                try {
                    this.trustStore = KeyStore.getInstance(options.getType());
                    in = new FileInputStream(options.getPath());
                    this.trustStore.load(in, options.getPassword().toCharArray());
                }
                catch (Exception e) {
                    this.trustStore = null;
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                stores.put(options, this.trustStore);
            }
            if (this.trustStore == null) {
                configuration.setVerifyRootCAEnabled(false);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String arg1) throws CertificateException {
        String peerIdentity;
        int i;
        int nSize = x509Certificates.length;
        List<String> peerIdentities = ServerTrustManager.getPeerIdentity(x509Certificates[0]);
        if (this.configuration.isVerifyChainEnabled()) {
            Principal principalLast = null;
            for (i = nSize - 1; i >= 0; --i) {
                X509Certificate x509certificate = x509Certificates[i];
                Principal principalIssuer = x509certificate.getIssuerDN();
                Principal principalSubject = x509certificate.getSubjectDN();
                if (principalLast != null) {
                    if (((Object)principalIssuer).equals(principalLast)) {
                        try {
                            PublicKey publickey = x509Certificates[i + 1].getPublicKey();
                            x509Certificates[i].verify(publickey);
                        }
                        catch (GeneralSecurityException generalsecurityexception) {
                            throw new CertificateException("signature verification failed of " + peerIdentities);
                        }
                    } else {
                        throw new CertificateException("subject/issuer verification failed of " + peerIdentities);
                    }
                }
                principalLast = principalSubject;
            }
        }
        if (this.configuration.isVerifyRootCAEnabled()) {
            boolean trusted = false;
            try {
                boolean bl = trusted = this.trustStore.getCertificateAlias(x509Certificates[nSize - 1]) != null;
                if (!trusted && nSize == 1 && this.configuration.isSelfSignedCertificateEnabled()) {
                    System.out.println("Accepting self-signed certificate of remote server: " + peerIdentities);
                    trusted = true;
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            if (!trusted) {
                throw new CertificateException("root certificate not trusted of " + peerIdentities);
            }
        }
        if (this.configuration.isNotMatchingDomainCheckEnabled() && (peerIdentities.size() == 1 && peerIdentities.get(0).startsWith("*.") ? !this.server.endsWith(peerIdentity = peerIdentities.get(0).replace("*.", "")) : !peerIdentities.contains(this.server))) {
            throw new CertificateException("target verification failed of " + peerIdentities);
        }
        if (this.configuration.isExpiredCertificatesCheckEnabled()) {
            Date date = new Date();
            for (i = 0; i < nSize; ++i) {
                try {
                    x509Certificates[i].checkValidity(date);
                    continue;
                }
                catch (GeneralSecurityException generalsecurityexception) {
                    throw new CertificateException("invalid date of " + this.server);
                }
            }
        }
    }

    public static List<String> getPeerIdentity(X509Certificate x509Certificate) {
        List<String> names = ServerTrustManager.getSubjectAlternativeNames(x509Certificate);
        if (names.isEmpty()) {
            String name = x509Certificate.getSubjectDN().getName();
            Matcher matcher = cnPattern.matcher(name);
            if (matcher.find()) {
                name = matcher.group(2);
            }
            names = new ArrayList<String>();
            names.add(name);
        }
        return names;
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate certificate) {
        ArrayList<String> identities = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
        }
        return identities;
    }

    private static class KeyStoreOptions {
        private final String type;
        private final String path;
        private final String password;

        public KeyStoreOptions(String type, String path, String password) {
            this.type = type;
            this.path = path;
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public String getPassword() {
            return this.password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyStoreOptions other = (KeyStoreOptions)obj;
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

