/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.logging.StandardLoggerFactory;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.util.StringUtil;

public final class Logger {
    private static volatile LoggerFactory loggerFactory;
    private static final Object FACTORY_LOCK;

    private Logger() {
    }

    public static ILogger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        LoggerFactory loggerFactoryToUse = loggerFactory;
        if (loggerFactoryToUse != null) {
            return loggerFactoryToUse.getLogger(name);
        }
        Object object = FACTORY_LOCK;
        synchronized (object) {
            if (loggerFactory == null) {
                String loggerClass = System.getProperty("hazelcast.logging.class");
                if (!StringUtil.isNullOrEmpty(loggerClass)) {
                    loggerFactory = loggerFactoryToUse = Logger.loadLoggerFactory(loggerClass);
                } else {
                    String loggerType = System.getProperty("hazelcast.logging.type");
                    loggerFactoryToUse = Logger.newLoggerFactory(loggerType);
                    if (!StringUtil.isNullOrEmpty(loggerType)) {
                        loggerFactory = loggerFactoryToUse;
                    }
                }
            }
        }
        if (loggerFactoryToUse == null) {
            loggerFactoryToUse = loggerFactory;
        }
        return loggerFactoryToUse.getLogger(name);
    }

    public static ILogger noLogger() {
        return new NoLogFactory.NoLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggerFactory newLoggerFactory(String loggerType) {
        LoggerFactory loggerFactory = null;
        String loggerClass = System.getProperty("hazelcast.logging.class");
        if (loggerClass != null) {
            loggerFactory = Logger.loadLoggerFactory(loggerClass);
        }
        if (loggerFactory == null && loggerType != null) {
            if ("log4j".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("com.hazelcast.logging.Log4jFactory");
            } else if ("log4j2".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("com.hazelcast.logging.Log4j2Factory");
            } else if ("slf4j".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("com.hazelcast.logging.Slf4jFactory");
            } else if ("jdk".equals(loggerType)) {
                loggerFactory = new StandardLoggerFactory();
            } else if ("none".equals(loggerType)) {
                loggerFactory = new NoLogFactory();
            }
        }
        if (loggerFactory == null) {
            loggerFactory = new StandardLoggerFactory();
        }
        if (Logger.loggerFactory == null) {
            Object object = FACTORY_LOCK;
            synchronized (object) {
                if (Logger.loggerFactory == null) {
                    Logger.loggerFactory = loggerFactory;
                }
            }
        }
        return loggerFactory;
    }

    private static LoggerFactory loadLoggerFactory(String className) {
        try {
            return (LoggerFactory)ClassLoaderUtil.newInstance(null, className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        FACTORY_LOCK = new Object();
    }
}

