/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelInboundHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.internal.networking.nio.ChannelInboundHandlerWithCounters;
import com.hazelcast.internal.networking.spinning.AbstractHandler;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SpinningChannelReader
extends AbstractHandler {
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final ChannelInitializer initializer;
    private volatile long lastReadTime;
    private ChannelInboundHandler inboundHandler;
    private ByteBuffer inputBuffer;

    public SpinningChannelReader(Channel channel, ILogger logger, ChannelErrorHandler errorHandler, ChannelInitializer initializer) {
        super(channel, logger, errorHandler);
        this.initializer = initializer;
    }

    public long lastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    public SwCounter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    public SwCounter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    public void read() throws Exception {
        if (this.channel.isClosed()) {
            this.channel.closeInbound();
            return;
        }
        if (this.inboundHandler == null && !this.init()) {
            return;
        }
        int readBytes = this.channel.read(this.inputBuffer);
        if (readBytes <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.lastReadTime = System.currentTimeMillis();
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.inboundHandler.onRead(this.inputBuffer);
        IOUtil.compactOrClear(this.inputBuffer);
    }

    private boolean init() throws IOException {
        InitResult<ChannelInboundHandler> init = this.initializer.initInbound(this.channel);
        if (init == null) {
            return false;
        }
        this.inboundHandler = init.getHandler();
        this.inputBuffer = init.getByteBuffer();
        if (this.inboundHandler instanceof ChannelInboundHandlerWithCounters) {
            ChannelInboundHandlerWithCounters withCounters = (ChannelInboundHandlerWithCounters)this.inboundHandler;
            withCounters.setNormalPacketsRead(this.normalFramesRead);
            withCounters.setPriorityPacketsRead(this.priorityFramesRead);
        }
        return true;
    }
}

