/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.chatroom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openymsg.network.Util;
import org.openymsg.network.chatroom.YahooChatCategory;
import org.openymsg.network.chatroom.YahooChatLobby;

public class ChatroomManager {
    public static final int REFRESH_TIMOUT_IN_SECONDS = 900;
    public static final String PREFIX = "http://";
    public static final String TOP_URL = "insider.msg.yahoo.com/ycontent/?chatcat=0";
    private static final Map<String, YahooChatCategory> roots = new HashMap<String, YahooChatCategory>();
    private static final Map<String, Long> timestamps = new HashMap<String, Long>();
    private final String cLine;
    private final String localePrefix;

    public ChatroomManager(String[] sessionCookies, String localePrefix) {
        this.cLine = sessionCookies != null ? sessionCookies[0] + "; " + sessionCookies[1] : null;
        this.localePrefix = localePrefix == null ? "" : (localePrefix.endsWith(".") ? localePrefix : localePrefix + ".");
    }

    private void recursiveLoad(Element parentElement, YahooChatCategory parentCategory, String cookieLine) {
        List childCategories = parentElement.getChildren("category");
        for (Element e : childCategories) {
            long id = Long.parseLong(e.getAttributeValue("id"));
            String name = e.getAttributeValue("name");
            YahooChatCategory yahooCategory = new YahooChatCategory(id, name, cookieLine, this.localePrefix);
            this.recursiveLoad(e, yahooCategory, cookieLine);
            parentCategory.addSubcategory(yahooCategory);
        }
    }

    public synchronized YahooChatCategory loadCategories() throws MalformedURLException, JDOMException, IOException {
        long timeout;
        long currentTimestamp = System.currentTimeMillis();
        if (timestamps.containsKey(this.localePrefix) && (timeout = timestamps.get(this.localePrefix).longValue()) + 900000L > currentTimestamp) {
            return roots.get(this.localePrefix);
        }
        String addr = PREFIX + this.localePrefix + TOP_URL;
        URLConnection uConn = new URL(addr).openConnection();
        Util.initURLConnection(uConn);
        if (this.cLine != null) {
            uConn.setRequestProperty("Cookie", this.cLine);
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new URL(addr));
        Element content = doc.getRootElement();
        YahooChatCategory root = new YahooChatCategory(Long.parseLong(content.getAttributeValue("time")), "<root>", this.cLine, this.localePrefix);
        this.recursiveLoad(content.getChild("chatCategories"), root, this.cLine);
        timestamps.put(this.localePrefix, currentTimestamp);
        roots.put(this.localePrefix, root);
        return root;
    }

    public YahooChatLobby getLobby(String networkName) {
        YahooChatCategory root = roots.get(this.localePrefix);
        if (root == null) {
            throw new IllegalStateException("Root category for this locale (" + this.localePrefix + ") has not been loaded yet.");
        }
        return root.getLobby(networkName);
    }
}

