/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelURLImpl;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.parser.URLParser;
import java.text.ParseException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.address.URI;

public class AddressFactoryImpl
implements AddressFactory {
    public Address createAddress(String string, URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("null  URI");
        }
        AddressImpl addressImpl = new AddressImpl();
        if (string != null) {
            addressImpl.setDisplayName(string);
        }
        addressImpl.setURI(uRI);
        return addressImpl;
    }

    public SipURI createSipURI(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null URI");
        }
        try {
            StringMsgParser stringMsgParser = new StringMsgParser();
            SipUri sipUri = stringMsgParser.parseSIPUrl(string);
            return sipUri;
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), 0);
        }
    }

    public SipURI createSipURI(String string, String string2) throws ParseException {
        if (string2 == null) {
            throw new NullPointerException("null host");
        }
        StringBuffer stringBuffer = new StringBuffer("sip:");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("@");
        }
        if (string2.indexOf(58) != string2.lastIndexOf(58) && string2.trim().charAt(0) != '[') {
            string2 = '[' + string2 + ']';
        }
        stringBuffer.append(string2);
        StringMsgParser stringMsgParser = new StringMsgParser();
        try {
            SipUri sipUri = stringMsgParser.parseSIPUrl(stringBuffer.toString());
            return sipUri;
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), 0);
        }
    }

    public TelURL createTelURL(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null url");
        }
        String string2 = "tel:" + string;
        try {
            StringMsgParser stringMsgParser = new StringMsgParser();
            TelURLImpl telURLImpl = (TelURLImpl)stringMsgParser.parseUrl(string2);
            return telURLImpl;
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), 0);
        }
    }

    public Address createAddress(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("null address");
        }
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.setURI(uRI);
        return addressImpl;
    }

    public Address createAddress(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null address");
        }
        if (string.equals("*")) {
            AddressImpl addressImpl = new AddressImpl();
            addressImpl.setAddressType(3);
            SipUri sipUri = new SipUri();
            sipUri.setUser("*");
            addressImpl.setURI(sipUri);
            return addressImpl;
        }
        StringMsgParser stringMsgParser = new StringMsgParser();
        return stringMsgParser.parseAddress(string);
    }

    public URI createURI(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        try {
            URLParser uRLParser = new URLParser(string);
            String string2 = uRLParser.peekScheme();
            if (string2 == null) {
                throw new ParseException("bad scheme", 0);
            }
            if (string2.equalsIgnoreCase("sip")) {
                return uRLParser.sipURL();
            }
            if (string2.equalsIgnoreCase("sips")) {
                return uRLParser.sipURL();
            }
            if (string2.equalsIgnoreCase("tel")) {
                return uRLParser.telURL();
            }
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), 0);
        }
        return new GenericURI(string);
    }
}

