/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.soap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnContactPending;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.impl.MsnGroupImpl;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingADL;
import net.sf.jml.protocol.outgoing.OutgoingBLP;
import net.sf.jml.protocol.outgoing.OutgoingCHG;
import net.sf.jml.protocol.outgoing.OutgoingRML;
import net.sf.jml.protocol.outgoing.OutgoingUUX;
import net.sf.jml.protocol.soap.DummyTrustManager;
import net.sf.jml.protocol.soap.SSO;
import net.sf.jml.protocol.soap.XmlEntity;
import net.sf.jml.util.XmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ContactList {
    private static final Log logger = LogFactory.getLog(ContactList.class);
    private SSO sso;
    private MsnSession session;
    private static final String membership_url = "https://omega.contacts.msn.com/abservice/SharingService.asmx";
    private static final String membership_soap = "http://www.msn.com/webservices/AddressBook/FindMembership";
    private static final String membership_soap_delete = "http://www.msn.com/webservices/AddressBook/DeleteMember";
    private static final String membership_soap_add = "http://www.msn.com/webservices/AddressBook/AddMember";
    private static final String addressbook_url = "https://omega.contacts.msn.com/abservice/abservice.asmx";
    private static final String addressbook_action_findall = "http://www.msn.com/webservices/AddressBook/ABFindAll";
    private static final String addressbook_action_add = "http://www.msn.com/webservices/AddressBook/ABAdd";
    private static final String addressbook_action_groupadd = "http://www.msn.com/webservices/AddressBook/ABGroupAdd";
    private static final String addressbook_action_groupdelete = "http://www.msn.com/webservices/AddressBook/ABGroupDelete";
    private static final String addressbook_action_groupupdate = "http://www.msn.com/webservices/AddressBook/ABGroupUpdate";
    private static final String addressbook_action_contactadd = "http://www.msn.com/webservices/AddressBook/ABContactAdd";
    private static final String addressbook_action_groupContactAdd = "http://www.msn.com/webservices/AddressBook/ABGroupContactAdd";
    private static final String addressbook_action_groupContactDelete = "http://www.msn.com/webservices/AddressBook/ABGroupContactDelete";
    private static final String addressbook_action_contactdelete = "http://www.msn.com/webservices/AddressBook/ABContactDelete";
    private static final String addressbook_action_contactupdate = "http://www.msn.com/webservices/AddressBook/ABContactUpdate";
    private Hashtable membersRoles = new Hashtable();
    private String myDisplayName = null;
    private static final String PREF_HOTNAME_NODE_START = "<PreferredHostName>";
    private static final String PREF_HOTNAME_NODE_END = "</PreferredHostName>";
    private static boolean ADLSent = false;
    private static boolean firstADLReply = true;

    ContactList() {
        this(null);
    }

    public ContactList(MsnSession msnSession) {
        this.sso = msnSession.getSSO();
        this.session = msnSession;
        this.membersRoles.put("Allow", new MemberRole("Allow", MsnList.AL));
        this.membersRoles.put("Block", new MemberRole("Block", MsnList.BL));
        this.membersRoles.put("Reverse", new MemberRole("Reverse", MsnList.RL));
        this.membersRoles.put("Pending", new MemberRole("Pending", MsnList.PL));
    }

    private synchronized String sendRequest(String string, String string2, String string3, String string4) {
        return this.sendRequest(string, string2, string3, string4, false);
    }

    private synchronized String sendRequest(String string, String string2, String string3, String string4, boolean bl) {
        DefaultHttpClientConnection defaultHttpClientConnection = new DefaultHttpClientConnection();
        BasicHttpParams basicHttpParams = null;
        BasicHttpProcessor basicHttpProcessor = null;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            SSLContext sSLContext;
            logger.trace((Object)("Will send body: " + string));
            URL uRL = new URL(string2);
            if (basicHttpParams == null) {
                basicHttpParams = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
                HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)false);
                basicHttpProcessor = new BasicHttpProcessor();
                basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
                basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
                basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
                basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
                basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
            }
            HttpRequestExecutor httpRequestExecutor = new HttpRequestExecutor();
            BasicHttpContext basicHttpContext = new BasicHttpContext(null);
            HttpHost httpHost = new HttpHost(uRL.getHost(), 443, "https");
            basicHttpContext.setAttribute("http.connection", (Object)defaultHttpClientConnection);
            basicHttpContext.setAttribute("http.target_host", (Object)httpHost);
            if (!defaultHttpClientConnection.isOpen()) {
                sSLContext = SSLContext.getInstance("SSLv3");
                trustManagerArray = new TrustManager[]{new DummyTrustManager()};
                sSLContext.init(null, trustManagerArray, null);
                object = sSLContext.getSocketFactory();
                Socket socket = ((SocketFactory)object).createSocket(httpHost.getHostName(), httpHost.getPort());
                defaultHttpClientConnection.bind(socket, (HttpParams)basicHttpParams);
            }
            sSLContext = new BasicHttpEntityEnclosingRequest(string4, uRL.getPath());
            sSLContext.setEntity((HttpEntity)new XmlEntity(string));
            basicHttpContext.setAttribute("http.request", (Object)sSLContext);
            sSLContext.setParams((HttpParams)basicHttpParams);
            if (string3 != null) {
                sSLContext.addHeader("SOAPAction", string3);
            }
            sSLContext.addHeader("Host", uRL.getHost());
            sSLContext.addHeader("Accept", "text/*");
            httpRequestExecutor.preProcess((HttpRequest)sSLContext, (HttpProcessor)basicHttpProcessor, (HttpContext)basicHttpContext);
            trustManagerArray = httpRequestExecutor.execute((HttpRequest)sSLContext, (HttpClientConnection)defaultHttpClientConnection, (HttpContext)basicHttpContext);
            httpRequestExecutor.postProcess((HttpResponse)trustManagerArray, (HttpProcessor)basicHttpProcessor, (HttpContext)basicHttpContext);
            object = EntityUtils.toString((HttpEntity)trustManagerArray.getEntity());
            logger.debug((Object)(trustManagerArray.getStatusLine() + " / " + (String)object));
            try {
                defaultHttpClientConnection.close();
            }
            catch (Exception exception) {
                logger.error((Object)"error closing connection", (Throwable)exception);
            }
            basicHttpParams = null;
            if (trustManagerArray.getStatusLine().getStatusCode() != 200) {
                if (!bl) {
                    int n = -1;
                    n = ((String)object).indexOf(PREF_HOTNAME_NODE_START);
                    if (n != -1) {
                        int n2 = ((String)object).indexOf(PREF_HOTNAME_NODE_END, n);
                        String string5 = ((String)object).substring(n + PREF_HOTNAME_NODE_START.length(), n2);
                        String string6 = new URL(string2).getHost();
                        String string7 = string2.replace(string6, string5);
                        return this.sendRequest(string, string7, string3, string4, true);
                    }
                }
                logger.error((Object)"something wrong!", (Throwable)new Exception());
                logger.info((Object)("Error xml:" + (String)object));
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            logger.error((Object)"Sending request", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long l) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getRequestBody(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
        stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
        stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
        stringBuilder.append("<soap:Header>\r\n");
        stringBuilder.append(" <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("  <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>\r\n");
        stringBuilder.append("   <IsMigration>false</IsMigration>\r\n");
        stringBuilder.append("   <PartnerScenario>Initial</PartnerScenario>\r\n");
        stringBuilder.append("  </ABApplicationHeader>\r\n");
        stringBuilder.append("  <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("   <ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
        stringBuilder.append("   <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
        stringBuilder.append("  </ABAuthHeader>\r\n");
        stringBuilder.append("</soap:Header>\r\n");
        stringBuilder.append("<soap:Body>\r\n");
        if (bl) {
            stringBuilder.append("<ABFindAll xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
            stringBuilder.append(" <abId>00000000-0000-0000-0000-000000000000</abId>\r\n");
            stringBuilder.append(" <abView>Full</abView>\r\n");
            stringBuilder.append(" <deltasOnly>false</deltasOnly>\r\n");
            stringBuilder.append(" <lastChange>0001-01-01T00:00:00.0000000-08:00</lastChange>\r\n");
            stringBuilder.append("</ABFindAll>\r\n");
        } else {
            stringBuilder.append("<FindMembership xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
            stringBuilder.append(" <serviceFilter>\r\n");
            stringBuilder.append("  <Types>\r\n");
            stringBuilder.append("   <ServiceType>Messenger</ServiceType>\r\n");
            stringBuilder.append("   <ServiceType>Invitation</ServiceType>\r\n");
            stringBuilder.append("   <ServiceType>SocialNetwork</ServiceType>\r\n");
            stringBuilder.append("   <ServiceType>Space</ServiceType>\r\n");
            stringBuilder.append("   <ServiceType>Profile</ServiceType>\r\n");
            stringBuilder.append("  </Types>\r\n");
            stringBuilder.append(" </serviceFilter>\r\n");
            stringBuilder.append("</FindMembership>\r\n");
        }
        stringBuilder.append("</soap:Body>\r\n");
        stringBuilder.append("</soap:Envelope>");
        return stringBuilder.toString();
    }

    private String getRequestBodyAddressBookAdd() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
        stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
        stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
        stringBuilder.append("<soap:Header>\r\n");
        stringBuilder.append("<ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>\r\n");
        stringBuilder.append("<IsMigration>false</IsMigration>\r\n");
        stringBuilder.append("<PartnerScenario>Initial</PartnerScenario>\r\n");
        stringBuilder.append("</ABApplicationHeader>\r\n");
        stringBuilder.append("<ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
        stringBuilder.append("<TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
        stringBuilder.append("</ABAuthHeader>\r\n");
        stringBuilder.append("</soap:Header>\r\n");
        stringBuilder.append("<soap:Body>\r\n");
        stringBuilder.append("<ABAdd xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<abInfo>\r\n");
        stringBuilder.append("<name/>\r\n");
        stringBuilder.append("<ownerPuid>0</ownerPuid>\r\n");
        stringBuilder.append("<ownerEmail> " + this.session.getMessenger().getOwner().getEmail().getEmailAddress() + " </ownerEmail>\r\n");
        stringBuilder.append("<fDefault>true</fDefault>\r\n");
        stringBuilder.append("</abInfo>\r\n");
        stringBuilder.append("</ABAdd>\r\n");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        return stringBuilder.toString();
    }

    public void dispatch() {
        String string = this.sendRequest(this.getRequestBody(false), membership_url, membership_soap, "POST");
        this.processMembers(string);
        this.waitFor(400L);
        String string2 = this.sendRequest(this.getRequestBody(true), addressbook_url, addressbook_action_findall, "POST");
        if (string2 == null) {
            this.sendRequest(this.getRequestBodyAddressBookAdd(), addressbook_url, addressbook_action_add, "POST");
            this.waitFor(400L);
            string2 = this.sendRequest(this.getRequestBody(true), addressbook_url, addressbook_action_findall, "POST");
        }
        this.processContactList(string2);
    }

    private String getContactID(String string, String string2) {
        Document document;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (Exception exception) {
            logger.error((Object)"", (Throwable)exception);
            return null;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABFindAllResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        Element element = XmlUtils.findChild((Element)object, "ABFindAllResult");
        Element element2 = XmlUtils.findChild(element, "contacts");
        if (element2 == null) {
            return null;
        }
        List list = XmlUtils.findChildren(element2, "Contact");
        for (Element element3 : list) {
            Element element4;
            Element element5;
            Element element6;
            String string3;
            Element element7;
            boolean bl;
            Element element8 = XmlUtils.findChild(element3, "contactId");
            String string4 = XmlUtils.getText(element8).trim();
            Element element9 = XmlUtils.findChild(element3, "contactInfo");
            Element element10 = XmlUtils.findChild(element9, "contactType");
            String string5 = XmlUtils.getText(element10);
            if (string5.equalsIgnoreCase("me") || !(bl = Boolean.parseBoolean(XmlUtils.getText(element7 = XmlUtils.findChild(element9, "isMessengerUser")))) || (string3 = XmlUtils.getText(element6 = XmlUtils.findChild(element9, "passportName"))) == null && ((element5 = XmlUtils.findChildByChain(element9, new String[]{"emails", "ContactEmail", "isMessengerEnabled"})) == null || !Boolean.parseBoolean(XmlUtils.getText(element5)) || (element4 = XmlUtils.findChildByChain(element9, new String[]{"emails", "ContactEmail", "email"})) == null || (string3 = XmlUtils.getText(element4)) == null) || !string3.equals(string2)) continue;
            return string4;
        }
        return null;
    }

    private void processContactList(String string) {
        Document document;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABFindAllResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        Element element = XmlUtils.findChild((Element)object, "ABFindAllResult");
        Element element2 = XmlUtils.findChild(element, "groups");
        Element element3 = XmlUtils.findChild(element, "contacts");
        this.processGroups(element2);
        this.processContacts(element3);
        AbstractMessenger abstractMessenger = (AbstractMessenger)this.session.getMessenger();
        abstractMessenger.fireContactListSyncCompleted();
        OutgoingBLP outgoingBLP = new OutgoingBLP(abstractMessenger.getActualMsnProtocol());
        outgoingBLP.setOnlyNotifyAllowList(false);
        abstractMessenger.send(outgoingBLP);
        this.sendContactList();
    }

    public void sendContactList() {
        AbstractMessenger abstractMessenger = (AbstractMessenger)this.session.getMessenger();
        MsnProtocol msnProtocol = abstractMessenger.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP12)) {
            MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
            MsnContact[] msnContactArray = msnContactListImpl.getContacts();
            int n = msnContactArray.length;
            LinkedList<MsnContact> linkedList = new LinkedList<MsnContact>();
            try {
                int n2 = 0;
                int n3 = 1;
                while (n2 < n) {
                    if (msnContactArray[n2] != null) {
                        linkedList.add(msnContactArray[n2]);
                    }
                    if (n3 == 220 || n2 == n - 1) {
                        OutgoingADL outgoingADL = new OutgoingADL(abstractMessenger.getActualMsnProtocol());
                        if (firstADLReply) {
                            ADLSent = n - 1 == n2;
                        }
                        outgoingADL.addContacts(linkedList.toArray(new MsnContact[n3]));
                        abstractMessenger.send(outgoingADL);
                        n3 = 0;
                        linkedList.clear();
                    }
                    ++n2;
                    ++n3;
                }
                firstADLReply = false;
            }
            catch (Exception exception) {
                logger.error((Object)("Contact list process error: " + exception.toString()));
            }
        }
    }

    public boolean isADLSent() {
        return ADLSent;
    }

    public void processInit() {
        MsnOutgoingMessage msnOutgoingMessage;
        AbstractMessenger abstractMessenger = (AbstractMessenger)this.session.getMessenger();
        MsnProtocol msnProtocol = abstractMessenger.getActualMsnProtocol();
        abstractMessenger.getOwner().setDisplayName(abstractMessenger.getOwner().getDisplayName());
        msnProtocol = abstractMessenger.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP9)) {
            msnOutgoingMessage = new OutgoingUUX(msnProtocol);
            ((OutgoingUUX)msnOutgoingMessage).setPersonalMessage(abstractMessenger.getOwner().getPersonalMessage());
            ((OutgoingUUX)msnOutgoingMessage).setMachineGuid("{F26D1F07-95E2-403C-BC18-D4BFED493428}");
            abstractMessenger.send(msnOutgoingMessage);
        }
        msnOutgoingMessage = new OutgoingCHG(msnProtocol);
        ((OutgoingCHG)msnOutgoingMessage).setStatus(abstractMessenger.getOwner().getInitStatus());
        ((OutgoingCHG)msnOutgoingMessage).setClientId(abstractMessenger.getOwner().getClientId());
        ((OutgoingCHG)msnOutgoingMessage).setDisplayPicture(abstractMessenger.getOwner().getDisplayPicture());
        ((OutgoingCHG)msnOutgoingMessage).setFirstSend(true);
        abstractMessenger.send(msnOutgoingMessage);
    }

    private void processGroups(Element element) {
        if (element == null) {
            return;
        }
        List list = XmlUtils.findChildren(element, "Group");
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        for (Element element2 : list) {
            Element element3 = XmlUtils.findChild(element2, "groupId");
            String string = XmlUtils.getText(element3).trim();
            Element element4 = XmlUtils.findChild(element2, "groupInfo");
            Element element5 = XmlUtils.findChild(element4, "name");
            String string2 = XmlUtils.getText(element5);
            MsnGroupImpl msnGroupImpl = new MsnGroupImpl(msnContactListImpl);
            msnGroupImpl.setGroupId(string);
            msnGroupImpl.setGroupName(string2);
            msnContactListImpl.addGroup(msnGroupImpl);
        }
    }

    private void processContacts(Element element) {
        if (element == null) {
            return;
        }
        List list = XmlUtils.findChildren(element, "Contact");
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        for (Element element2 : list) {
            Object object;
            Object object2;
            Element element3;
            Element element4;
            String string;
            Element element5;
            Element element6 = XmlUtils.findChild(element2, "contactId");
            MsnContactImpl msnContactImpl = new MsnContactImpl(msnContactListImpl);
            String string2 = XmlUtils.getText(element6).trim();
            msnContactImpl.setId(string2);
            Element element7 = XmlUtils.findChild(element2, "contactInfo");
            Element element8 = XmlUtils.findChild(element7, "contactType");
            String string3 = XmlUtils.getText(element8);
            if (string3.equalsIgnoreCase("me")) {
                element5 = XmlUtils.findChild(element7, "displayName");
                this.myDisplayName = XmlUtils.getText(element5);
                continue;
            }
            element5 = XmlUtils.findChild(element7, "isMessengerUser");
            boolean bl = Boolean.parseBoolean(XmlUtils.getText(element5));
            if (!bl || (string = XmlUtils.getText(element4 = XmlUtils.findChild(element7, "passportName"))) == null && ((element3 = XmlUtils.findChildByChain(element7, new String[]{"emails", "ContactEmail", "isMessengerEnabled"})) == null || !Boolean.parseBoolean(XmlUtils.getText(element3)) || (object2 = XmlUtils.findChildByChain(element7, new String[]{"emails", "ContactEmail", "email"})) == null || (string = XmlUtils.getText((Element)object2)) == null)) continue;
            msnContactImpl.setEmail(Email.parseStr(string));
            element3 = XmlUtils.findChild(element7, "groupIds");
            if (element3 != null) {
                object2 = XmlUtils.findChildren(element3, "guid");
                object = object2.iterator();
                while (object.hasNext()) {
                    Element element9 = (Element)object.next();
                    msnContactImpl.addBelongGroup(XmlUtils.getText(element9).trim());
                }
            }
            object2 = XmlUtils.findChild(element7, "displayName");
            object = XmlUtils.getText((Element)object2);
            msnContactImpl.setFriendlyName((String)object);
            msnContactImpl.setDisplayName((String)object);
            int n = 0;
            for (Map.Entry entry : this.membersRoles.entrySet()) {
                MemberRole memberRole = (MemberRole)entry.getValue();
                if (!memberRole.getMembers().contains(string)) continue;
                n += memberRole.list.getListId();
            }
            if (n == 0) continue;
            msnContactImpl.setListNumber(n);
            if (msnContactImpl.isInList(MsnList.AL)) {
                msnContactImpl.setInList(MsnList.FL, true);
            }
            if (msnContactImpl.isInList(MsnList.AL) && msnContactImpl.isInList(MsnList.BL)) {
                msnContactImpl.setInList(MsnList.FL, false);
                msnContactImpl.setInList(MsnList.AL, false);
                msnContactImpl.setInList(MsnList.PL, false);
            }
            if ((n | MsnList.RL.getListId()) == MsnList.RL.getListId()) {
                msnContactImpl.setInList(MsnList.PL, true);
            }
            msnContactListImpl.addContact(msnContactImpl);
        }
    }

    private void processMembers(String string) {
        Document document;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "FindMembershipResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        List list = XmlUtils.findChildrenByChain((Element)object, new String[]{"FindMembershipResult", "Services", "Service", "Memberships"});
        for (Element element : list) {
            List list2 = XmlUtils.findChildren(element, "Membership");
            for (Element element2 : list2) {
                String string2;
                Element element3;
                List list3;
                Element element4 = XmlUtils.findChild(element2, "MemberRole");
                String string3 = XmlUtils.getText(element4);
                MemberRole memberRole = (MemberRole)this.membersRoles.get(string3);
                if (memberRole == null) continue;
                if (string3.equals("Pending") && XmlUtils.getText((Element)XmlUtils.findChildrenByChain((Element)element.getParentNode(), new String[]{"Info", "Handle", "Type"}).get(0)).equals("Messenger")) {
                    list3 = XmlUtils.locateElements(element2, "Member", "xsi:type", "PassportMember");
                    for (Element element5 : list3) {
                        element3 = XmlUtils.findChild(element5, "DisplayName");
                        string2 = XmlUtils.getText(element3);
                        element3 = XmlUtils.findChild(element5, "JoinedDate");
                        Date date = null;
                        try {
                            date = DatatypeFactory.newInstance().newXMLGregorianCalendar(XmlUtils.getText(element3)).toGregorianCalendar().getTime();
                        }
                        catch (DatatypeConfigurationException datatypeConfigurationException) {
                            datatypeConfigurationException.printStackTrace();
                        }
                        element3 = XmlUtils.findChild(element5, "PassportName");
                        String string4 = XmlUtils.getText(element3);
                        ArrayList<MsnContactPending> arrayList = ((AbstractMessenger)this.session.getMessenger()).getPendingList();
                        arrayList.add(new MsnContactPending(Email.parseStr(string4), string2, date));
                        ((AbstractMessenger)this.session.getMessenger()).fireContactAddedMe(this.session.getMessenger().getPendingList().toArray(new MsnContactPending[0]));
                    }
                    continue;
                }
                list3 = XmlUtils.locateElements(element2, "Member", "xsi:type", "PassportMember");
                for (Element element5 : list3) {
                    element3 = XmlUtils.findChild(element5, "PassportName");
                    string2 = XmlUtils.getText(element3);
                    memberRole.addMember(string2);
                }
            }
        }
    }

    public void createGroup(String string) {
        Document document;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuilder.append("               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuilder.append("               xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuilder.append("               xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("    <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>");
        stringBuilder.append("        <IsMigration>false</IsMigration>");
        stringBuilder.append("        <PartnerScenario>GroupSave</PartnerScenario>");
        stringBuilder.append("    </ABApplicationHeader>");
        stringBuilder.append("    <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ManagedGroupRequest>false</ManagedGroupRequest>");
        stringBuilder.append("        <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>");
        stringBuilder.append("    </ABAuthHeader>");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("    <ABGroupAdd xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <abId>00000000-0000-0000-0000-000000000000</abId>");
        stringBuilder.append("        <groupAddOptions>");
        stringBuilder.append("           <fRenameOnMsgrConflict>false</fRenameOnMsgrConflict>");
        stringBuilder.append("        </groupAddOptions>");
        stringBuilder.append("        <groupInfo>");
        stringBuilder.append("           <GroupInfo>");
        stringBuilder.append("               <name>" + string + "</name>");
        stringBuilder.append("               <groupType>C8529CE2-6EAD-434d-881F-341E17DB3FF8</groupType>");
        stringBuilder.append("               <fMessenger>false</fMessenger>");
        stringBuilder.append("               <annotations>");
        stringBuilder.append("                  <Annotation>");
        stringBuilder.append("                      <Name>MSN.IM.Display</Name>");
        stringBuilder.append("                      <Value>1</Value>");
        stringBuilder.append("                  </Annotation>");
        stringBuilder.append("               </annotations>");
        stringBuilder.append("           </GroupInfo>");
        stringBuilder.append("        </groupInfo>");
        stringBuilder.append("    </ABGroupAdd>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        String string2 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_groupadd, "POST");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABGroupAddResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        Element element = XmlUtils.findChildByChain((Element)object, new String[]{"ABGroupAddResult", "guid"});
        if (element == null) {
            return;
        }
        String string3 = XmlUtils.getText(element);
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnGroupImpl msnGroupImpl = new MsnGroupImpl(msnContactListImpl);
        msnGroupImpl.setGroupId(string3);
        msnGroupImpl.setGroupName(string);
        msnContactListImpl.addGroup(msnGroupImpl);
        ((AbstractMessenger)this.session.getMessenger()).fireGroupAddCompleted(msnGroupImpl);
    }

    public void removeGroup(String string) {
        Document document;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
        stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
        stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
        stringBuilder.append("<soap:Header>\r\n");
        stringBuilder.append("<ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>\r\n");
        stringBuilder.append("<IsMigration>false</IsMigration>\r\n");
        stringBuilder.append("<PartnerScenario>Timer</PartnerScenario>\r\n");
        stringBuilder.append("</ABApplicationHeader>\r\n");
        stringBuilder.append("<ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
        stringBuilder.append("<TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
        stringBuilder.append("</ABAuthHeader>\r\n");
        stringBuilder.append("</soap:Header>\r\n");
        stringBuilder.append("<soap:Body>\r\n");
        stringBuilder.append("<ABGroupDelete xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<abId>00000000-0000-0000-0000-000000000000</abId>\r\n");
        stringBuilder.append("<groupFilter>\r\n");
        stringBuilder.append("<groupIds><guid>" + string + "</guid></groupIds>\r\n");
        stringBuilder.append("</groupFilter>\r\n");
        stringBuilder.append("</ABGroupDelete>\r\n");
        stringBuilder.append("</soap:Body>\r\n");
        stringBuilder.append("</soap:Envelope>");
        String string2 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_groupdelete, "POST");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABGroupDeleteResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (object == null || object.getChildNodes().getLength() > 0) {
            return;
        }
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnGroup msnGroup = msnContactListImpl.getGroup(string);
        msnContactListImpl.removeGroup(string);
        ((AbstractMessenger)this.session.getMessenger()).fireGroupRemoveCompleted(msnGroup);
    }

    public void renameGroup(String string, String string2) {
        Document document;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuilder.append("               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuilder.append("               xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuilder.append("               xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("    <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>");
        stringBuilder.append("        <IsMigration>false</IsMigration>");
        stringBuilder.append("        <PartnerScenario>GroupSave</PartnerScenario>");
        stringBuilder.append("    </ABApplicationHeader>");
        stringBuilder.append("    <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ManagedGroupRequest>false</ManagedGroupRequest>");
        stringBuilder.append("        <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>");
        stringBuilder.append("    </ABAuthHeader>");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("    <ABGroupUpdate xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <abId>00000000-0000-0000-0000-000000000000</abId>");
        stringBuilder.append("        <groups><Group>");
        stringBuilder.append("           <groupId>" + string + "</groupId>");
        stringBuilder.append("           <groupInfo><name>" + string2 + "</name></groupInfo>");
        stringBuilder.append("           <propertiesChanged>GroupName</propertiesChanged>");
        stringBuilder.append("        </Group></groups>");
        stringBuilder.append("    </ABGroupUpdate>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        String string3 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_groupupdate, "POST");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string3.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABGroupDeleteResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (object == null || object.getChildNodes().getLength() > 0) {
            return;
        }
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnGroupImpl msnGroupImpl = (MsnGroupImpl)msnContactListImpl.getGroup(string);
        if (msnGroupImpl != null) {
            msnGroupImpl.setGroupName(string2);
        }
    }

    public void addFriend(Email email, String string) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuilder.append("               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuilder.append("               xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuilder.append("               xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("    <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>");
        stringBuilder.append("        <IsMigration>false</IsMigration>");
        stringBuilder.append("        <PartnerScenario>ContactSave</PartnerScenario>");
        stringBuilder.append("    </ABApplicationHeader>");
        stringBuilder.append("    <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ManagedGroupRequest>false</ManagedGroupRequest>");
        stringBuilder.append("        <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>");
        stringBuilder.append("    </ABAuthHeader>");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("    <ABContactAdd xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <abId>00000000-0000-0000-0000-000000000000</abId>");
        stringBuilder.append("        <contacts>");
        stringBuilder.append("           <Contact xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("               <contactInfo>");
        stringBuilder.append("                   <contactType>LivePending</contactType>");
        stringBuilder.append("                   <passportName>" + email.getEmailAddress() + "</passportName>");
        stringBuilder.append("                   <isMessengerUser>true</isMessengerUser>");
        stringBuilder.append("                   <MessengerMemberInfo><DisplayName>" + string + "</DisplayName></MessengerMemberInfo>");
        stringBuilder.append("               </contactInfo>");
        stringBuilder.append("           </Contact>");
        stringBuilder.append("        </contacts>");
        stringBuilder.append("        <options><EnableAllowListManagement>true</EnableAllowListManagement></options>");
        stringBuilder.append("    </ABContactAdd>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        String string2 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_contactadd, "POST");
        String string3 = null;
        if (string2 != null) {
            Document document;
            Object object3;
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setIgnoringComments(true);
            try {
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                object3 = new ByteArrayInputStream(string2.getBytes("UTF-8"));
                document = ((DocumentBuilder)object).parse((InputStream)object3);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                logger.error((Object)"", (Throwable)parserConfigurationException);
                return;
            }
            catch (SAXException sAXException) {
                logger.error((Object)"", (Throwable)sAXException);
                return;
            }
            catch (IOException iOException) {
                logger.error((Object)"", (Throwable)iOException);
                return;
            }
            object3 = XmlUtils.locateElement(document.getDocumentElement(), "ABContactAddResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
            Element element = XmlUtils.findChildByChain((Element)object3, new String[]{"ABContactAddResult", "guid"});
            if (element == null) {
                return;
            }
            string3 = XmlUtils.getText(element);
        } else {
            object2 = this.sendRequest(this.getRequestBody(true), addressbook_url, addressbook_action_findall, "POST");
            string3 = this.getContactID((String)object2, email.getEmailAddress());
        }
        object2 = (MsnContactListImpl)this.session.getMessenger().getContactList();
        object = new MsnContactImpl((MsnContactList)object2);
        ((MsnContactImpl)object).setEmail(email);
        ((MsnContactImpl)object).setFriendlyName(string);
        ((MsnContactImpl)object).setId(string3);
        ((MsnContactListImpl)object2).addContact((MsnContact)object);
        this.addFriendToList(new MsnList[]{MsnList.AL, MsnList.FL}, (MsnContactImpl)object);
    }

    public void updateFriend(Email email, String string, String string2) {
        Document document;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.fatal((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        documentBuilderFactory.setIgnoringComments(true);
        Element element = null;
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnContactImpl msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactById(string);
        msnContactImpl.setFriendlyName(string2);
        stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
        stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
        stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
        stringBuilder.append("<soap:Header>\r\n");
        stringBuilder.append("<ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>\r\n");
        stringBuilder.append("<IsMigration>false</IsMigration>\r\n");
        stringBuilder.append("<PartnerScenario>Timer</PartnerScenario>\r\n");
        stringBuilder.append("</ABApplicationHeader>\r\n");
        stringBuilder.append("<ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
        stringBuilder.append("<TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
        stringBuilder.append("</ABAuthHeader>\r\n");
        stringBuilder.append("</soap:Header>\r\n");
        stringBuilder.append("<soap:Body>\r\n");
        stringBuilder.append("    <ABContactUpdate xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <abId>00000000-0000-0000-0000-000000000000</abId>");
        stringBuilder.append("        <contacts>");
        stringBuilder.append("           <Contact xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("               <contactId>" + string + "</contactId>");
        stringBuilder.append("               <contactInfo>");
        stringBuilder.append("                   <displayName>" + string2 + "</displayName>");
        stringBuilder.append("               </contactInfo>");
        stringBuilder.append("               <propertiesChanged>DisplayName</propertiesChanged>");
        stringBuilder.append("           </Contact>");
        stringBuilder.append("        </contacts>");
        stringBuilder.append("    </ABContactUpdate>");
        stringBuilder.append("</soap:Body>\r\n");
        stringBuilder.append("</soap:Envelope>");
        string3 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_contactupdate, "POST");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF-8"));
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        element = XmlUtils.locateElement(document.getDocumentElement(), "ABContactUpdateResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (element == null || element.getChildNodes().getLength() > 0) {
            return;
        }
        msnContactListImpl.removeContactById(string);
        msnContactListImpl.addContact(msnContactImpl);
    }

    public void addFriendToList(MsnList[] msnListArray, MsnContactImpl msnContactImpl) {
        Object object;
        for (int i = 0; i < msnListArray.length; ++i) {
            object = msnListArray[i];
            msnContactImpl.setInList((MsnList)object, true);
        }
        AbstractMessenger abstractMessenger = (AbstractMessenger)this.session.getMessenger();
        object = new OutgoingADL(abstractMessenger.getActualMsnProtocol());
        ((OutgoingADL)object).setContact(msnContactImpl);
        abstractMessenger.send((MsnOutgoingMessage)object);
    }

    public void removeFriend(MsnList msnList, Email email, String string, String string2) {
        Document document;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.fatal((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        documentBuilderFactory.setIgnoringComments(true);
        Element element = null;
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnContactImpl msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactById(string);
        if (string2 != null) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
            stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
            stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
            stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
            stringBuilder.append("<soap:Header>\r\n");
            stringBuilder.append("<ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
            stringBuilder.append("<ApplicationId>CFE80F9D-180F-4399-82AB-413F33A1FA11</ApplicationId>\r\n");
            stringBuilder.append("<IsMigration>false</IsMigration>\r\n");
            stringBuilder.append("<PartnerScenario>Timer</PartnerScenario>\r\n");
            stringBuilder.append("</ABApplicationHeader>\r\n");
            stringBuilder.append("<ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
            stringBuilder.append("<ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
            stringBuilder.append("<TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
            stringBuilder.append("</ABAuthHeader>\r\n");
            stringBuilder.append("</soap:Header>\r\n");
            stringBuilder.append("<soap:Body>\r\n");
            stringBuilder.append("<ABGroupContactDelete xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
            stringBuilder.append("<abId>00000000-0000-0000-0000-000000000000</abId>\r\n");
            stringBuilder.append("<contacts><Contact><contactId>" + string + "</contactId></Contact></contacts>\r\n");
            stringBuilder.append("<groupFilter><groupIds>\r\n");
            stringBuilder.append("<guid>" + string2 + "</guid>\r\n");
            stringBuilder.append("</groupIds></groupFilter>\r\n");
            stringBuilder.append("</ABGroupContactDelete>\r\n");
            stringBuilder.append("</soap:Body>\r\n");
            stringBuilder.append("</soap:Envelope>");
            string3 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_groupContactDelete, "POST");
            try {
                object = new ByteArrayInputStream(string3.getBytes());
                document = documentBuilder.parse((InputStream)object);
            }
            catch (SAXException sAXException) {
                logger.error((Object)"", (Throwable)sAXException);
                return;
            }
            catch (IOException iOException) {
                logger.error((Object)"", (Throwable)iOException);
                return;
            }
            element = XmlUtils.locateElement(document.getDocumentElement(), "ABGroupContactDeleteResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
            if (element == null || element.getChildNodes().getLength() > 0) {
                logger.error((Object)("some error in " + string3));
            } else {
                msnContactImpl.removeBelongGroup(string2);
                object = msnContactListImpl.getGroup(string2);
                ((AbstractMessenger)this.session.getMessenger()).fireContactRemoveFromGroupCompleted(msnContactImpl, (MsnGroup)object);
            }
        }
        if (msnContactImpl.getBelongGroups().length > 0) {
            return;
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
        stringBuilder.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        stringBuilder.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n");
        stringBuilder.append(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n");
        stringBuilder.append("<soap:Header>\r\n");
        stringBuilder.append("<ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>\r\n");
        stringBuilder.append("<IsMigration>false</IsMigration>\r\n");
        stringBuilder.append("<PartnerScenario>Timer</PartnerScenario>\r\n");
        stringBuilder.append("</ABApplicationHeader>\r\n");
        stringBuilder.append("<ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<ManagedGroupRequest>false</ManagedGroupRequest>\r\n");
        stringBuilder.append("<TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>\r\n");
        stringBuilder.append("</ABAuthHeader>\r\n");
        stringBuilder.append("</soap:Header>\r\n");
        stringBuilder.append("<soap:Body>\r\n");
        stringBuilder.append("<ABContactDelete xmlns=\"http://www.msn.com/webservices/AddressBook\">\r\n");
        stringBuilder.append("<abId>00000000-0000-0000-0000-000000000000</abId>\r\n");
        stringBuilder.append("<contacts><Contact><contactId>" + string + "</contactId></Contact></contacts>\r\n");
        stringBuilder.append("</ABContactDelete>\r\n");
        stringBuilder.append("</soap:Body>\r\n");
        stringBuilder.append("</soap:Envelope>");
        string3 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_contactdelete, "POST");
        try {
            object = new ByteArrayInputStream(string3.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        element = XmlUtils.locateElement(document.getDocumentElement(), "ABContactDeleteResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (element == null || element.getChildNodes().getLength() > 0) {
            return;
        }
        msnContactListImpl.removeContactById(string);
        object = (AbstractMessenger)this.session.getMessenger();
        OutgoingRML outgoingRML = new OutgoingRML(((AbstractMessenger)object).getActualMsnProtocol());
        outgoingRML.setRemoveFromList(msnList, msnContactImpl);
        ((AbstractMessenger)object).send(outgoingRML);
    }

    public void blockFriend(Email email) {
        Document document;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuilder.append("               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuilder.append("               xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuilder.append("               xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("    <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>");
        stringBuilder.append("        <IsMigration>false</IsMigration>");
        stringBuilder.append("        <PartnerScenario>BlockUnblock</PartnerScenario>");
        stringBuilder.append("    </ABApplicationHeader>");
        stringBuilder.append("    <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ManagedGroupRequest>false</ManagedGroupRequest>");
        stringBuilder.append("        <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>");
        stringBuilder.append("    </ABAuthHeader>");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("    <DeleteMember xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <serviceHandle><Id>0</Id><Type>Messenger</Type><ForeignId></ForeignId></serviceHandle>");
        stringBuilder.append("        <memberships><Membership>");
        stringBuilder.append("           <MemberRole>Block</MemberRole>");
        stringBuilder.append("           <Members><Member xsi:type=\"PassportMember\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        stringBuilder.append("               <Type>Passport</Type><State>Accepted</State><PassportName>" + email.getEmailAddress() + "</PassportName></Member></Members>");
        stringBuilder.append("        </Membership></memberships>");
        stringBuilder.append("    </DeleteMember>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        String string = this.sendRequest(stringBuilder.toString(), addressbook_url, membership_soap_delete, "POST");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "DeleteMemberResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (object == null || object.getChildNodes().getLength() > 0) {
            return;
        }
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnContactImpl msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactByEmail(email);
        msnContactImpl.setInList(MsnList.AL, false);
        msnContactImpl.setInList(MsnList.BL, true);
    }

    public void unblockFriend(Email email) {
    }

    public void copyFriend(Email email, String string) {
        Document document;
        Object object;
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnContactImpl msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactByEmail(email);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuilder.append("               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuilder.append("               xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuilder.append("               xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("    <ABApplicationHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ApplicationId>996CDE1E-AA53-4477-B943-2BE802EA6166</ApplicationId>");
        stringBuilder.append("        <IsMigration>false</IsMigration>");
        stringBuilder.append("        <PartnerScenario>GroupSave</PartnerScenario>");
        stringBuilder.append("    </ABApplicationHeader>");
        stringBuilder.append("    <ABAuthHeader xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <ManagedGroupRequest>false</ManagedGroupRequest>");
        stringBuilder.append("        <TicketToken>" + this.sso.getContactTicket().replaceAll("&", "&amp;") + "</TicketToken>");
        stringBuilder.append("    </ABAuthHeader>");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("    <ABGroupContactAdd xmlns=\"http://www.msn.com/webservices/AddressBook\">");
        stringBuilder.append("        <abId>00000000-0000-0000-0000-000000000000</abId>");
        stringBuilder.append("        <contacts><Contact><contactId>" + msnContactImpl.getId() + "</contactId></Contact></contacts>");
        stringBuilder.append("        <groupFilter><groupIds>");
        stringBuilder.append("           <guid>" + string + "</guid>");
        stringBuilder.append("        </groupIds></groupFilter>");
        stringBuilder.append("    </ABGroupContactAdd>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        String string2 = this.sendRequest(stringBuilder.toString(), addressbook_url, addressbook_action_groupContactAdd, "POST");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            object = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            document = documentBuilder.parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)"", (Throwable)parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            logger.error((Object)"", (Throwable)sAXException);
            return;
        }
        catch (IOException iOException) {
            logger.error((Object)"", (Throwable)iOException);
            return;
        }
        object = XmlUtils.locateElement(document.getDocumentElement(), "ABGroupContactAddResponse", "xmlns", "http://www.msn.com/webservices/AddressBook");
        if (object == null) {
            return;
        }
        if ((object = XmlUtils.findChildByChain((Element)object, new String[]{"ABGroupContactAddResult", "guid"})) != null) {
            msnContactImpl.addBelongGroup(string);
            MsnGroup msnGroup = msnContactListImpl.getGroup(string);
            ((AbstractMessenger)this.session.getMessenger()).fireContactAddInGroupCompleted(msnContactImpl, msnGroup);
        }
    }

    public void moveFriend(Email email, String string, String string2) {
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)this.session.getMessenger().getContactList();
        MsnContact msnContact = msnContactListImpl.getContactByEmail(email);
        this.copyFriend(email, string2);
        this.removeFriend(MsnList.FL, email, msnContact.getId(), string);
    }

    private class MemberRole {
        String name;
        MsnList list;
        Vector members = new Vector();

        MemberRole(String string, MsnList msnList) {
            this.name = string;
            this.list = msnList;
        }

        void addMember(String string) {
            this.members.add(string);
        }

        Vector getMembers() {
            return this.members;
        }
    }
}

