/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.ValueCollectionFactory;
import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.hazelcast.multimap.impl.operations.RemoveAllOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;

public class RemoveAllRequest
extends MultiMapKeyBasedRequest {
    long threadId;

    public RemoveAllRequest() {
    }

    public RemoveAllRequest(String name, Data key, long threadId) {
        super(name, key);
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveAllOperation(this.name, this.key, this.threadId);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("t", this.threadId);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("t");
        super.read(reader);
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof MultiMapResponse) {
            Collection responseCollection = ((MultiMapResponse)response).getCollection();
            if (responseCollection == null) {
                return new PortableCollection();
            }
            Collection<Data> collection = ValueCollectionFactory.createCollection(responseCollection);
            for (MultiMapRecord record : responseCollection) {
                collection.add((Data)this.serializationService.toData(record.getObject()));
            }
            return new PortableCollection(collection);
        }
        return super.filter(response);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

