/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.net.ClientConn;
import net.kano.joustsim.oscar.AbstractConnListener;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AuthorizingStateInfo;
import net.kano.joustsim.oscar.ConnectingStateInfo;
import net.kano.joustsim.oscar.ConnectionFailedStateInfo;
import net.kano.joustsim.oscar.DisconnectedStateInfo;
import net.kano.joustsim.oscar.LoginFailureStateInfo;
import net.kano.joustsim.oscar.NotConnectedStateInfo;
import net.kano.joustsim.oscar.OnlineStateInfo;
import net.kano.joustsim.oscar.OscarConnectionPreparer;
import net.kano.joustsim.oscar.SigningOnStateInfo;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateInfo;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.LoginConnection;
import net.kano.joustsim.oscar.oscar.LoginServiceListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginSuccessInfo;
import net.kano.joustsim.oscar.oscar.service.MutableService;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceImpl;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyServiceImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmServiceImpl;
import net.kano.joustsim.oscar.oscar.service.info.InfoServiceImpl;
import net.kano.joustsim.oscar.oscar.service.login.LoginService;
import net.kano.joustsim.oscar.oscar.service.mailcheck.MailCheckService;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServiceImpl;

public final class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class.getName());
    private boolean triedConnecting = false;
    private State state = State.NOTCONNECTED;
    private StateInfo stateInfo = NotConnectedStateInfo.getInstance();
    private boolean wantedDisconnect = false;
    private CopyOnWriteArrayList<StateListener> stateListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OscarConnectionPreparer> preparers = new CopyOnWriteArrayList();
    private final LoginConnection loginConn;
    private BasicConnection mainConn = null;
    private final AimConnection aimConnection;
    private String password;

    ConnectionManager(AimConnection conn, AimConnectionProperties props) {
        this.aimConnection = conn;
        this.loginConn = new LoginConnection(props.getLoginHost(), props.getLoginPort());
        this.password = props.getPassword();
        this.loginConn.addOscarListener(new LoginConnListener());
        this.loginConn.setServiceFactory(new LoginServiceFactory());
    }

    public void addConnectionPreparer(OscarConnectionPreparer preparer) {
        this.preparers.addIfAbsent((Object)preparer);
    }

    public void removeConnectionPreparer(OscarConnectionPreparer preparer) {
        this.preparers.remove((Object)preparer);
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized StateInfo getStateInfo() {
        return this.stateInfo;
    }

    public void addStateListener(StateListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.stateListeners.addIfAbsent((Object)l);
    }

    public void removeStateListener(StateListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.stateListeners.remove((Object)l);
    }

    public synchronized boolean triedConnecting() {
        return this.triedConnecting;
    }

    private synchronized boolean setTriedConnecting() {
        if (this.triedConnecting) {
            return false;
        }
        this.triedConnecting = true;
        return true;
    }

    public boolean connect() {
        this.setTriedConnecting();
        this.loginConn.getClientFlapConn().setSocketFactory(this.aimConnection.getProxy().getSocketFactory());
        for (OscarConnectionPreparer l : this.preparers) {
            l.prepareLoginConnection(this, this.loginConn);
        }
        this.loginConn.connect();
        this.setState(State.NOTCONNECTED, State.CONNECTINGAUTH, new AuthorizingStateInfo(this.loginConn));
        return true;
    }

    public synchronized void disconnect(boolean onPurpose) {
        this.wantedDisconnect = onPurpose;
        this.closeConnections();
    }

    public synchronized boolean wantedDisconnect() {
        return this.wantedDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(State expectedOld, State state, StateInfo info) {
        StateInfo oldStateInfo;
        State oldState;
        DefensiveTools.checkNull((Object)state, (String)"state");
        DefensiveTools.checkNull((Object)info, (String)"info");
        LOGGER.fine("New state: " + state + " - " + info);
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            oldState = this.state;
            oldStateInfo = this.stateInfo;
            if (expectedOld != null && oldState != expectedOld) {
                LOGGER.warning("Tried converting state " + expectedOld + " to " + state + ", but was in " + oldState);
                return false;
            }
            this.state = state;
            this.stateInfo = info;
        }
        StateEvent event = new StateEvent(this.aimConnection, oldState, oldStateInfo, state, info);
        for (StateListener listener : this.stateListeners) {
            listener.handleStateChange(event);
        }
        return true;
    }

    private void connectBos(LoginSuccessInfo info) {
        BasicConnection mainConn = this.prepareMainConn(info);
        mainConn.connect();
        this.setState(State.AUTHORIZING, State.CONNECTING, new ConnectingStateInfo(info));
    }

    private synchronized BasicConnection prepareMainConn(LoginSuccessInfo info) {
        if (this.state != State.AUTHORIZING) {
            throw new IllegalStateException("tried to connect to BOS server in state " + this.state);
        }
        BasicConnection mainConn = new BasicConnection(info.getServer(), info.getPort());
        mainConn.getClientFlapConn().setSocketFactory(this.aimConnection.getProxy().getSocketFactory());
        mainConn.setCookie(info.getCookie());
        mainConn.addOscarListener(new MainBosConnListener());
        mainConn.setServiceFactory(new BasicServiceFactory());
        for (OscarConnectionPreparer l : this.preparers) {
            l.prepareMainBosConnection(this, mainConn);
        }
        this.mainConn = mainConn;
        return mainConn;
    }

    private void internalDisconnected() {
        this.setState(null, State.DISCONNECTED, new DisconnectedStateInfo(this.wantedDisconnect()));
        this.closeConnections();
    }

    private synchronized void closeConnections() {
        this.loginConn.disconnect();
        BasicConnection mainConn = this.mainConn;
        if (mainConn != null) {
            mainConn.disconnect();
        }
    }

    public LoginConnection getLoginConnection() {
        return this.loginConn;
    }

    private class MainBosConnListener
    extends AbstractConnListener {
        private MainBosConnListener() {
        }

        public void allFamiliesReady(OscarConnection conn) {
            if (ConnectionManager.this.getState() == State.CONNECTING) {
                LOGGER.log(Level.FINER, "State was CONNECTING, but now we're ONLINE. The state should've been SIGNINGON.", new Throwable());
                ConnectionManager.this.setState(State.CONNECTING, State.SIGNINGON, new SigningOnStateInfo());
            }
            ConnectionManager.this.setState(State.SIGNINGON, State.ONLINE, new OnlineStateInfo());
        }

        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_FAILED) {
                ConnectionManager.this.setState(null, State.FAILED, new ConnectionFailedStateInfo(conn.getHost(), conn.getPort()));
            } else if (state == ClientConn.STATE_NOT_CONNECTED) {
                ConnectionManager.this.internalDisconnected();
            } else if (state == ClientConn.STATE_CONNECTED) {
                ConnectionManager.this.setState(State.CONNECTING, State.SIGNINGON, new SigningOnStateInfo());
            }
        }
    }

    private class LoginProcessListener
    implements LoginServiceListener {
        private LoginProcessListener() {
        }

        public void loginSucceeded(LoginSuccessInfo info) {
            ConnectionManager.this.connectBos(info);
        }

        public void loginFailed(LoginFailureInfo info) {
            ConnectionManager.this.setState(null, State.FAILED, new LoginFailureStateInfo(info));
        }
    }

    private class LoginConnListener
    extends AbstractConnListener {
        private LoginConnListener() {
        }

        public void registeredSnacFamilies(OscarConnection conn) {
            assert (conn instanceof LoginConnection) : "Expected LoginConnection, got " + conn;
            LoginService ls = ((LoginConnection)conn).getLoginService();
            ls.addLoginListener(new LoginProcessListener());
        }

        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_CONNECTED) {
                ConnectionManager.this.setState(State.CONNECTINGAUTH, State.AUTHORIZING, new AuthorizingStateInfo(ConnectionManager.this.loginConn));
            }
        }
    }

    private class BasicServiceFactory
    implements ServiceFactory {
        private BasicServiceFactory() {
        }

        public MutableService getService(OscarConnection conn, int family) {
            if (family == 1) {
                return new MainBosServiceImpl(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 4) {
                return new IcbmServiceImpl(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 3) {
                return new BuddyServiceImpl(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 2) {
                return new InfoServiceImpl(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 19) {
                return new SsiServiceImpl(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 24) {
                return new MailCheckService(ConnectionManager.this.aimConnection, conn);
            }
            LOGGER.warning("No service for family 0x" + Integer.toHexString(family));
            return null;
        }
    }

    private class LoginServiceFactory
    implements ServiceFactory {
        private LoginServiceFactory() {
        }

        public MutableService getService(OscarConnection conn, int family) {
            if (family == 23) {
                return new LoginService(ConnectionManager.this.aimConnection, ConnectionManager.this.loginConn, ConnectionManager.this.aimConnection.getScreenname(), ConnectionManager.this.password);
            }
            return null;
        }
    }
}

