/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.v3.QueryExecutorImpl;

class ProtocolConnectionImpl
implements ProtocolConnection {
    private String serverVersion;
    private int cancelPid;
    private int cancelKey;
    private int transactionState;
    private SQLWarning warnings;
    private boolean closed = false;
    private final ArrayList notifications = new ArrayList();
    private final PGStream pgStream;
    private final String user;
    private final String database;
    private final QueryExecutorImpl executor;

    ProtocolConnectionImpl(PGStream pgStream, String user, String database, Properties info) {
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.executor = new QueryExecutorImpl(this, pgStream, info);
    }

    public String getHost() {
        return this.pgStream.getHost();
    }

    public int getPort() {
        return this.pgStream.getPort();
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public synchronized int getTransactionState() {
        return this.transactionState;
    }

    public synchronized PGNotification[] getNotifications() throws SQLException {
        this.executor.processNotifies();
        PGNotification[] array = this.notifications.toArray(new PGNotification[this.notifications.size()]);
        this.notifications.clear();
        return array;
    }

    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendQueryCancel() throws SQLException {
        PGStream cancelStream = null;
        try {
            try {
                if (Driver.logDebug) {
                    Driver.debug(" FE=> CancelRequest(pid=" + this.cancelPid + ",ckey=" + this.cancelKey + ")");
                }
                cancelStream = new PGStream(this.pgStream.getHost(), this.pgStream.getPort());
                cancelStream.SendInteger4(16);
                cancelStream.SendInteger2(1234);
                cancelStream.SendInteger2(5678);
                cancelStream.SendInteger4(this.cancelPid);
                cancelStream.SendInteger4(this.cancelKey);
                cancelStream.flush();
                cancelStream.close();
                return;
            }
            catch (IOException e) {
                if (Driver.logDebug) {
                    Driver.debug("Ignoring exception on cancel request:", e);
                }
                Object var4_3 = null;
                if (cancelStream == null) return;
                try {
                    cancelStream.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (cancelStream == null) throw throwable;
            try {
                cancelStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void close() {
        block4: {
            if (this.closed) {
                return;
            }
            try {
                if (Driver.logDebug) {
                    Driver.debug(" FE=> Terminate");
                }
                this.pgStream.SendChar(88);
                this.pgStream.SendInteger4(4);
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException ioe) {
                if (!Driver.logDebug) break block4;
                Driver.debug("Discarding IOException on close:", ioe);
            }
        }
        this.closed = true;
    }

    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    public boolean isClosed() {
        return this.closed;
    }

    void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    synchronized void addNotification(PGNotification notification) {
        this.notifications.add(notification);
    }

    synchronized void setTransactionState(int state) {
        this.transactionState = state;
    }

    public int getProtocolVersion() {
        return 3;
    }
}

