/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Identifiable;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResolvingPropertyEditor<T extends Identifiable<Integer>>
extends PropertyEditorSupport {
    private Object service;
    private Method finderMethod;

    public EntityResolvingPropertyEditor(Class<T> clazz, Object service, String finderMethodName) {
        this.service = service;
        try {
            this.finderMethod = service.getClass().getMethod(finderMethodName, Integer.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not resolve method " + finderMethodName + " in class " + service.getClass());
        }
    }

    public EntityResolvingPropertyEditor(Class<T> clazz, Object service) {
        this(clazz, service, "find" + clazz.getSimpleName() + "ById");
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            Integer id = new Integer(text);
            this.setValue(this.finderMethod.invoke(this.service, id));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not resolve id " + text, e);
        }
    }
}

