/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.jms;

import com.voxeo.jms.ConnectionState;
import com.voxeo.jms.IRobustMessageClient;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Networks;
import java.io.Serializable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobustMessageClient
implements IRobustMessageClient {
    private Loggerf log = Loggerf.getLogger(RobustMessageClient.class);
    private String hostName;
    private Destination pingQueue;
    private Destination messageQueue;
    private JmsOperations jmsTemplate;
    private long sleepTime;
    private int maxRetriesOnErrorWhileConnected = 1;
    private ConnectionState connectionState;
    private boolean initialPingSent = false;
    private final MessageCreator pingCreator = new MessageCreator(){
        Message message = null;

        public Message createMessage(Session session) throws JMSException {
            if (this.message == null) {
                this.message = session.createTextMessage(RobustMessageClient.this.getHostName());
                RobustMessageClient.this.decorateMessage(this.message, null);
            }
            return this.message;
        }
    };

    public void setPingQueue(Destination pingQueue) {
        this.pingQueue = pingQueue;
    }

    public void setMessageQueue(Destination vlfQueue) {
        this.messageQueue = vlfQueue;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setMaxRetriesOnErrorWhileConnected(int maxRetriesOnErrorWhileConnected) {
        this.maxRetriesOnErrorWhileConnected = maxRetriesOnErrorWhileConnected;
    }

    public void initialize() throws InterruptedException {
        this.hostName = this.getHostName();
        this.ping(false, false);
    }

    @Override
    public void send(byte[] bytes) throws InterruptedException {
        this.send(bytes, null);
    }

    @Override
    public void send(Serializable object) throws InterruptedException {
        this.send(object, null);
    }

    @Override
    public void send(String text) throws InterruptedException {
        this.send(text, null);
    }

    @Override
    public void send(final byte[] bytes, final Map<String, ?> properties) throws InterruptedException {
        this.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(bytes);
                RobustMessageClient.this.decorateMessage((Message)message, properties);
                return message;
            }
        });
    }

    @Override
    public void send(final Serializable object, final Map<String, ?> properties) throws InterruptedException {
        this.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage(object);
                RobustMessageClient.this.decorateMessage((Message)message, properties);
                return message;
            }
        });
    }

    @Override
    public void send(final String text, final Map<String, ?> properties) throws InterruptedException {
        this.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage(text);
                RobustMessageClient.this.decorateMessage((Message)message, properties);
                return message;
            }
        });
    }

    private void decorateMessage(Message message, Map<String, ?> properties) throws JMSException {
        message.setStringProperty("com.voxeo.jms.host.name", this.hostName);
        if (properties != null) {
            for (String key : properties.keySet()) {
                Object value = properties.get(key);
                message.setObjectProperty(key, value);
            }
        }
    }

    private void send(MessageCreator messageCreator) throws InterruptedException {
        if (!this.initialPingSent) {
            this.ping(true, false);
        }
        this.sendWithRetry(this.messageQueue, messageCreator);
    }

    private void sendWithRetry(Destination destination, MessageCreator messageCreator) throws InterruptedException {
        boolean loggedConnectionMessage = false;
        int retriesOnErrorWhileConnected = 0;
        boolean reconnectAttempt = false;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (destination != this.pingQueue && reconnectAttempt) {
                    this.ping(false, true);
                    reconnectAttempt = false;
                }
                this.jmsTemplate.send(destination, messageCreator);
                break;
            }
            catch (JmsException e) {
                if (!this.connectionState.isConnected()) {
                    if (this.sleepTime == 0L) {
                        this.log.error("%s lost connection to broker, won't retry", this.getHostName());
                        throw e;
                    }
                    if (!loggedConnectionMessage) {
                        this.log.error("%s lost connection to broker, will continue to retry...", this.getHostName());
                        loggedConnectionMessage = true;
                    }
                    this.log.debug("No connection to broker, sleeping...", new Object[0]);
                    reconnectAttempt = true;
                    Thread.sleep(this.sleepTime);
                    continue;
                }
                if (retriesOnErrorWhileConnected < this.maxRetriesOnErrorWhileConnected) {
                    this.log.info("Received exception while connected, retrying...", new Object[]{e});
                    ++retriesOnErrorWhileConnected;
                    continue;
                }
                this.log.info("Received exception while connected %d times, send failed...", this.maxRetriesOnErrorWhileConnected + 1);
                throw e;
            }
        }
    }

    public void ping(boolean retry, boolean throwError) throws InterruptedException {
        try {
            if (retry) {
                this.sendWithRetry(this.pingQueue, this.pingCreator);
            } else {
                this.jmsTemplate.send(this.pingQueue, this.pingCreator);
            }
            this.initialPingSent = true;
        }
        catch (JmsException e) {
            if (throwError) {
                throw e;
            }
            this.log.error("%s couldn't send test connection message, check the address of the broker: %s", this.hostName, e.getMessage());
        }
    }

    private String getHostName() {
        if (this.hostName == null) {
            this.hostName = Networks.getLocalhostName();
        }
        return this.hostName;
    }
}

