/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractInCommand;
import f00f.net.irc.martyr.util.FullNick;
import f00f.net.irc.martyr.util.ParameterIterator;
import org.apache.log4j.Logger;

public class WelcomeCommand
extends AbstractInCommand {
    static Logger log = Logger.getLogger(WelcomeCommand.class);
    private String notice;
    private String nick;

    public WelcomeCommand() {
        this(null, null);
    }

    public WelcomeCommand(String nick, String notice) {
        this.notice = notice;
        this.nick = nick;
        log.debug((Object)("WelcomeCommand: Nick is: `" + nick + "'"));
        log.debug((Object)("WelcomeCommand: Notice is: `" + notice + "'"));
    }

    public InCommand parse(String prefix, String identifier, String params) {
        String notice;
        ParameterIterator pi = new ParameterIterator(params);
        String nick = pi.next().toString();
        if (pi.hasNext()) {
            notice = pi.next().toString();
        } else {
            notice = nick;
            nick = null;
        }
        if (pi.hasNext()) {
            log.fatal((Object)"WelcomeCommand: More than two parameters, confused.");
        }
        return new WelcomeCommand(nick, notice);
    }

    public boolean updateClientState(ClientState state) {
        log.debug((Object)("WelcomeCommand: updated client state with: " + new FullNick(this.nick)));
        state.setNick(new FullNick(this.nick));
        return true;
    }

    public String getIrcIdentifier() {
        return "001";
    }

    public void selfRegister(CommandRegister commandRegister) {
        commandRegister.addCommand("001", this);
        commandRegister.addCommand("002", this);
        commandRegister.addCommand("003", this);
        commandRegister.addCommand("004", this);
        commandRegister.addCommand("005", this);
    }

    public String getNotice() {
        return this.notice;
    }

    public String getNick() {
        return this.nick;
    }

    public String toString() {
        return "WelcomeCommand";
    }
}

