/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.Writable;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptReqRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_MODULUS = 1001;
    private static final int TYPE_PUBLICVALUE = 1002;
    private final BigInteger modulus;
    private final BigInteger publicValue;

    public TrillianCryptReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getExtraTlvs();
        Tlv pTlv = chain.getLastTlv(1001);
        this.modulus = pTlv != null ? TrillianCryptReqRvCmd.getBigIntFromHexBlock(pTlv.getData()) : null;
        Tlv gTlv = chain.getLastTlv(1002);
        this.publicValue = gTlv != null ? TrillianCryptReqRvCmd.getBigIntFromHexBlock(gTlv.getData()) : null;
    }

    public TrillianCryptReqRvCmd(BigInteger modulus, BigInteger publicValue) {
        super(0);
        this.modulus = modulus;
        this.publicValue = publicValue;
    }

    public final BigInteger getModulus() {
        return this.modulus;
    }

    public final BigInteger getPublicValue() {
        return this.publicValue;
    }

    protected void writeExtraTlvs(OutputStream out) throws IOException {
        if (this.modulus != null) {
            ByteBlock modBlock = ByteBlock.wrap((byte[])TrillianCryptReqRvCmd.getBigIntHexBlock(this.modulus));
            new Tlv(1001, (Writable)modBlock).write(out);
        }
        if (this.publicValue != null) {
            ByteBlock pubBlock = ByteBlock.wrap((byte[])TrillianCryptReqRvCmd.getBigIntHexBlock(this.publicValue));
            new Tlv(1002, (Writable)pubBlock).write(out);
        }
    }

    public String toString() {
        return "TrillianEncryptReqRvCmd: modulus=" + this.modulus + ", public value=" + this.publicValue;
    }
}

