/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.AbstractTokenRequest;
import pl.mn.communicator.packet.http.CommonRegisterResponse;
import pl.mn.communicator.packet.http.HttpResponse;

public class UnregisterGGPasswordRequest
extends AbstractTokenRequest {
    private int m_uin = -1;
    private String m_password = null;

    public UnregisterGGPasswordRequest(IGGConfiguration configuration, int uin, String password, String tokenID, String tokenVal) throws IOException {
        super(configuration, tokenID, tokenVal);
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        this.m_uin = uin;
        this.m_password = password;
    }

    public HttpResponse getResponse() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_huc.getInputStream(), "windows-1250"));
        String line = reader.readLine();
        return new CommonRegisterResponse(this.m_uin, line);
    }

    protected String getURL() {
        return this.m_ggconfiguration.getRegistrationURL();
    }

    protected String getRequestBody() throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("fmnumber=");
        buffer.append(this.m_uin);
        buffer.append('&');
        buffer.append("fmpwd=");
        buffer.append(URLEncoder.encode(this.m_password, "windows-1250"));
        buffer.append('&');
        buffer.append("delete=1");
        buffer.append('&');
        buffer.append("email=");
        buffer.append("deletedaccount@gadu-gadu.pl");
        buffer.append('&');
        buffer.append("pwd=");
        buffer.append("2D388046464");
        buffer.append('&');
        buffer.append("tokenid=");
        buffer.append(this.getTokenID());
        buffer.append('&');
        buffer.append("tokenval=");
        buffer.append(this.getTokenVal());
        buffer.append('&');
        buffer.append("code=");
        buffer.append(this.getHashCode("deletedaccount@gadu-gadu.pl", "2D388046464"));
        return buffer.toString();
    }

    protected boolean wannaWrite() {
        return true;
    }
}

