/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="ITopic")
public class TopicMBean
extends HazelcastMBean<ITopic> {
    private final AtomicLong totalMessageCount = new AtomicLong();
    private final String registrationId;

    protected TopicMBean(ITopic managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("ITopic", managedObject.getName());
        MessageListener messageListener = new MessageListener(){

            public void onMessage(Message message) {
                TopicMBean.this.totalMessageCount.incrementAndGet();
            }
        };
        this.registrationId = managedObject.addMessageListener(messageListener);
    }

    @ManagedAnnotation(value="localCreationTime")
    @ManagedDescription(value="the creation time of this topic on this member")
    public long getLocalCreationTime() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getCreationTime();
    }

    @ManagedAnnotation(value="localPublishOperationCount")
    @ManagedDescription(value=" the total number of published messages of this topic on this member")
    public long getLocalPublishOperationCount() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getPublishOperationCount();
    }

    @ManagedAnnotation(value="localReceiveOperationCount")
    @ManagedDescription(value="the total number of received messages of this topic on this member")
    public long getLocalReceiveOperationCount() {
        return ((ITopic)this.managedObject).getLocalTopicStats().getReceiveOperationCount();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((ITopic)this.managedObject).getName();
    }

    @ManagedAnnotation(value="totalMessageCount")
    public long getTotalMessageCount() {
        return this.totalMessageCount.get();
    }

    @ManagedAnnotation(value="config")
    public String getConfig() {
        Config config = this.service.instance.getConfig();
        TopicConfig topicConfig = config.findTopicConfig(((ITopic)this.managedObject).getName());
        return topicConfig.toString();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        try {
            ((ITopic)this.managedObject).removeMessageListener(this.registrationId);
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
    }
}

