/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheDestroyRequest
extends ClientRequest {
    private static final int TRY_COUNT = 100;
    private String name;
    private int partitionId;

    public CacheDestroyRequest() {
    }

    public CacheDestroyRequest(String name, int partitionId) {
        this.name = name;
        this.partitionId = partitionId;
    }

    @Override
    public final void process() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        Operation op = this.prepareOperation();
        op.setCallerUuid(endpoint.getUuid());
        InvocationBuilder builder = this.operationService.createInvocationBuilder(this.getServiceName(), op, this.partitionId);
        builder.setTryCount(100).setResultDeserialized(false).setCallback(new Callback<Object>(){

            @Override
            public void notify(Object object) {
                endpoint.sendResponse(object, CacheDestroyRequest.this.getCallId());
            }
        });
        builder.invoke();
    }

    protected Operation prepareOperation() {
        return new CacheDestroyOperation(this.name);
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.partitionId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.partitionId = reader.readInt("p");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

