/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;

public final class GetOperation
extends KeyBasedMapOperation
implements IdentifiedDataSerializable,
WaitSupport,
ReadonlyOperation {
    private Data result;

    public GetOperation() {
    }

    public GetOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        this.result = mapServiceContext.toData(this.recordStore.get(this.dataKey, false));
    }

    @Override
    public void afterRun() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        mapServiceContext.interceptAfterGet(this.name, this.result);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.recordStore.isTransactionallyLocked(this.dataKey)) {
            return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public String toString() {
        return "GetOperation{" + this.name + "}";
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

