/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.MultiMap;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;

@ManagedDescription(value="MultiMap")
public class MultiMapMBean
extends HazelcastMBean<MultiMap> {
    protected MultiMapMBean(MultiMap managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("MultiMap", managedObject.getName());
    }

    @ManagedAnnotation(value="localOwnedEntryCount")
    @ManagedDescription(value="number of entries owned on this member")
    public long getLocalOwnedEntryCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getOwnedEntryCount();
    }

    @ManagedAnnotation(value="localBackupEntryCount")
    @ManagedDescription(value="the number of backup entries hold on this member")
    public long getLocalBackupEntryCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getBackupEntryCount();
    }

    @ManagedAnnotation(value="localBackupCount")
    @ManagedDescription(value="the number of backups per entry on this member")
    public int getLocalBackupCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getBackupCount();
    }

    @ManagedAnnotation(value="localOwnedEntryMemoryCost")
    @ManagedDescription(value="memory cost (number of bytes) of owned entries on this member")
    public long getLocalOwnedEntryMemoryCost() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getOwnedEntryMemoryCost();
    }

    @ManagedAnnotation(value="localBackupEntryMemoryCost")
    @ManagedDescription(value="memory cost (number of bytes) of backup entries on this member.")
    public long getLocalBackupEntryMemoryCost() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getBackupEntryMemoryCost();
    }

    @ManagedAnnotation(value="localCreationTime")
    @ManagedDescription(value="the creation time of this map on this member.")
    public long getLocalCreationTime() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getCreationTime();
    }

    @ManagedAnnotation(value="localLastAccessTime")
    @ManagedDescription(value="the last access (read) time of the locally owned entries.")
    public long getLocalLastAccessTime() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getLastAccessTime();
    }

    @ManagedAnnotation(value="localLastUpdateTime")
    @ManagedDescription(value="the last update time of the locally owned entries.")
    public long getLocalLastUpdateTime() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getLastUpdateTime();
    }

    @ManagedAnnotation(value="localHits")
    @ManagedDescription(value="the number of hits (reads) of the locally owned entries.")
    public long getLocalHits() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getHits();
    }

    @ManagedAnnotation(value="localLockedEntryCount")
    @ManagedDescription(value="the number of currently locked locally owned keys.")
    public long getLocalLockedEntryCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getLockedEntryCount();
    }

    @ManagedAnnotation(value="localDirtyEntryCount")
    @ManagedDescription(value="the number of entries that the member owns and are dirty on this member")
    public long getLocalDirtyEntryCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getDirtyEntryCount();
    }

    @ManagedAnnotation(value="localPutOperationCount")
    @ManagedDescription(value="the number of put operations on this member")
    public long getLocalPutOperationCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getPutOperationCount();
    }

    @ManagedAnnotation(value="localGetOperationCount")
    @ManagedDescription(value="number of get operations on this member")
    public long getLocalGetOperationCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getGetOperationCount();
    }

    @ManagedAnnotation(value="localRemoveOperationCount")
    @ManagedDescription(value="number of remove operations on this member")
    public long getLocalRemoveOperationCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getRemoveOperationCount();
    }

    @ManagedAnnotation(value="localTotalPutLatency")
    @ManagedDescription(value="the total latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalTotalPutLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getTotalPutLatency();
    }

    @ManagedAnnotation(value="localTotalGetLatency")
    @ManagedDescription(value="the total latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalTotalGetLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getTotalGetLatency();
    }

    @ManagedAnnotation(value="localTotalRemoveLatency")
    @ManagedDescription(value="the total latency of remove operations. To get the average latency, divide to number of gets")
    public long getLocalTotalRemoveLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getTotalRemoveLatency();
    }

    @ManagedAnnotation(value="localMaxPutLatency")
    @ManagedDescription(value="the maximum latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalMaxPutLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getMaxPutLatency();
    }

    @ManagedAnnotation(value="localMaxGetLatency")
    @ManagedDescription(value="the maximum latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalMaxGetLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getMaxGetLatency();
    }

    @ManagedAnnotation(value="localMaxRemoveLatency")
    @ManagedDescription(value="the maximum latency of remove operations. To get the average latency, divide to number of gets")
    public long getMaxRemoveLatency() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getMaxRemoveLatency();
    }

    @ManagedAnnotation(value="localEventOperationCount")
    @ManagedDescription(value="number of events received on this member")
    public long getLocalEventOperationCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getEventOperationCount();
    }

    @ManagedAnnotation(value="localOtherOperationCount")
    @ManagedDescription(value="the total number of other operations on this member")
    public long getLocalOtherOperationCount() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().getOtherOperationCount();
    }

    @ManagedAnnotation(value="localTotal")
    @ManagedDescription(value="the total number of operations on this member")
    public long localTotal() {
        return ((MultiMap)this.managedObject).getLocalMultiMapStats().total();
    }

    @ManagedAnnotation(value="name")
    public String getName() {
        return ((MultiMap)this.managedObject).getName();
    }

    @ManagedAnnotation(value="clear", operation=true)
    public void clear() {
        ((MultiMap)this.managedObject).clear();
    }

    @ManagedAnnotation(value="size")
    public int getSize() {
        return ((MultiMap)this.managedObject).size();
    }
}

