/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.collection.client;

import com.hazelcast.collection.impl.collection.client.CollectionRequest;
import com.hazelcast.collection.impl.collection.operations.CollectionAddOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionAddRequest
extends CollectionRequest {
    protected Data value;

    public CollectionAddRequest() {
    }

    public CollectionAddRequest(String name, Data value) {
        super(name);
        this.value = value;
    }

    @Override
    protected Operation prepareOperation() {
        return new CollectionAddOperation(this.name, this.value);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.getRawDataOutput().writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.value = reader.getRawDataInput().readData();
    }

    @Override
    public String getRequiredAction() {
        return "add";
    }

    @Override
    public String getMethodName() {
        return "add";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

