/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.nio.Address;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientGetPartitionsCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_GETPARTITIONS;
    public static final int RESPONSE_TYPE = 110;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(Address[] members, int[] ownerIndexes) {
        int requiredDataSize = ResponseParameters.calculateDataSize(members, ownerIndexes);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(110);
        clientMessage.set(members.length);
        for (Address members_item : members) {
            AddressCodec.encode(members_item, clientMessage);
        }
        clientMessage.set(ownerIndexes.length);
        for (int ownerIndexes_item : ownerIndexes) {
            clientMessage.set(ownerIndexes_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        Address[] members = null;
        int members_size = clientMessage.getInt();
        members = new Address[members_size];
        for (int members_index = 0; members_index < members_size; ++members_index) {
            Address members_item;
            members[members_index] = members_item = AddressCodec.decode(clientMessage);
        }
        parameters.members = members;
        int[] ownerIndexes = null;
        int ownerIndexes_size = clientMessage.getInt();
        ownerIndexes = new int[ownerIndexes_size];
        for (int ownerIndexes_index = 0; ownerIndexes_index < ownerIndexes_size; ++ownerIndexes_index) {
            int ownerIndexes_item;
            ownerIndexes[ownerIndexes_index] = ownerIndexes_item = clientMessage.getInt();
        }
        parameters.ownerIndexes = ownerIndexes;
        return parameters;
    }

    public static class ResponseParameters {
        public Address[] members;
        public int[] ownerIndexes;

        public static int calculateDataSize(Address[] members, int[] ownerIndexes) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Address members_item : members) {
                dataSize += AddressCodec.calculateDataSize(members_item);
            }
            dataSize += 4;
            for (int ownerIndexes_item : ownerIndexes) {
                dataSize += 4;
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

