/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorInputStream
extends InputStream {
    private final Selector selector = Selector.open();
    private final ReadableByteChannel readable;
    private final SelectableChannel selectable;

    private SelectorInputStream(Channel channel) throws IOException {
        this((ReadableByteChannel)channel, (SelectableChannel)channel);
    }

    public SelectorInputStream(ReadableByteChannel readable, SelectableChannel selectable) throws IOException {
        this.readable = readable;
        this.selectable = selectable;
        this.selectable.configureBlocking(false);
        this.selectable.register(this.selector, 1);
    }

    public static <C extends SelectableChannel> SelectorInputStream getInstance(C channel) throws IOException {
        return new SelectorInputStream(channel);
    }

    @Override
    public void close() throws IOException {
        this.readable.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        assert (buf.position() == off);
        while (buf.hasRemaining() && this.selector.isOpen() && this.readable.isOpen()) {
            this.selector.select(50L);
            int ct = this.readable.read(buf);
            if (ct == -1 && buf.position() == off) {
                return -1;
            }
            if (ct != -1 && ct <= 0) continue;
            break;
        }
        return buf.position() - off;
    }

    @Override
    public int read() throws IOException {
        int ct;
        ByteBuffer buf = ByteBuffer.allocate(1);
        do {
            this.selector.select(50L);
            ct = this.readable.read(buf);
            if (ct != -1) continue;
            return -1;
        } while (ct <= 0);
        return buf.get(0);
    }
}

