/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.InternetProtocolFamily;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final NioDatagramPipelineSink sink;
    private final WorkerPool<NioDatagramWorker> workerPool;
    private final InternetProtocolFamily family;

    public NioDatagramChannelFactory() {
        this((Executor)Executors.newCachedThreadPool(), null);
    }

    public NioDatagramChannelFactory(InternetProtocolFamily family) {
        this((Executor)Executors.newCachedThreadPool(), family);
    }

    public NioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount) {
        this(new NioDatagramWorkerPool(workerExecutor, workerCount, true));
    }

    public NioDatagramChannelFactory(WorkerPool<NioDatagramWorker> workerPool) {
        this(workerPool, null);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, InternetProtocolFamily family) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS, family);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount, InternetProtocolFamily family) {
        this(new NioDatagramWorkerPool(workerExecutor, workerCount, true), family);
    }

    public NioDatagramChannelFactory(WorkerPool<NioDatagramWorker> workerPool, InternetProtocolFamily family) {
        this.workerPool = workerPool;
        this.family = family;
        this.sink = new NioDatagramPipelineSink(workerPool);
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.sink.nextWorker(), this.family);
    }

    @Override
    public void releaseExternalResources() {
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
    }
}

