/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.LspQuant;

public class HighLspQuant
extends LspQuant {
    public final void quant(float[] lsp, float[] qlsp, int order, Bits bits) {
        int i;
        float[] quant_weight = new float[20];
        for (i = 0; i < order; ++i) {
            qlsp[i] = lsp[i];
        }
        quant_weight[0] = 1.0f / (qlsp[1] - qlsp[0]);
        quant_weight[order - 1] = 1.0f / (qlsp[order - 1] - qlsp[order - 2]);
        for (i = 1; i < order - 1; ++i) {
            float tmp1 = 1.0f / (qlsp[i] - qlsp[i - 1]);
            float tmp2 = 1.0f / (qlsp[i + 1] - qlsp[i]);
            quant_weight[i] = tmp1 > tmp2 ? tmp1 : tmp2;
        }
        for (i = 0; i < order; ++i) {
            int n = i;
            qlsp[n] = (float)((double)qlsp[n] - (0.3125 * (double)i + 0.75));
        }
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = qlsp[n] * 256.0f;
        }
        int id = HighLspQuant.lsp_quant(qlsp, 0, high_lsp_cdbk, 64, order);
        bits.pack(id, 6);
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = qlsp[n] * 2.0f;
        }
        id = HighLspQuant.lsp_weight_quant(qlsp, 0, quant_weight, 0, high_lsp_cdbk2, 64, order);
        bits.pack(id, 6);
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = (float)((double)qlsp[n] * 0.0019531);
        }
        for (i = 0; i < order; ++i) {
            qlsp[i] = lsp[i] - qlsp[i];
        }
    }

    public final void unquant(float[] lsp, int order, Bits bits) {
        for (int i = 0; i < order; ++i) {
            lsp[i] = 0.3125f * (float)i + 0.75f;
        }
        this.unpackPlus(lsp, high_lsp_cdbk, bits, 0.0039062f, order, 0);
        this.unpackPlus(lsp, high_lsp_cdbk2, bits, 0.0019531f, order, 0);
    }
}

