/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;

public class GetPartitionsMessageTask
extends AbstractCallableMessageTask<ClientGetPartitionsCodec.RequestParameters> {
    public GetPartitionsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        InternalPartitionService service = (InternalPartitionService)this.getService("hz:core:partitionService");
        service.firstArrangement();
        ClusterService clusterService = (ClusterService)this.getService("hz:core:clusterService");
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        Address[] addresses = new Address[memberList.size()];
        HashMap<Address, Integer> addressMap = new HashMap<Address, Integer>(memberList.size());
        int k = 0;
        for (MemberImpl member : memberList) {
            Address address;
            addresses[k] = address = member.getAddress();
            addressMap.put(address, k);
            ++k;
        }
        InternalPartition[] partitions = service.getPartitions();
        int[] indexes = new int[partitions.length];
        for (int i = 0; i < indexes.length; ++i) {
            Address owner = partitions[i].getOwnerOrNull();
            int index = -1;
            if (owner == null) {
                return ClientGetPartitionsCodec.encodeResponse(new Address[0], new int[0]);
            }
            Integer idx = (Integer)addressMap.get(owner);
            if (idx != null) {
                index = idx;
            }
            indexes[i] = index;
        }
        return ClientGetPartitionsCodec.encodeResponse(addresses, indexes);
    }

    @Override
    protected ClientGetPartitionsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientGetPartitionsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

