/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.awt.Color;
import java.io.IOException;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class MinMax {
    MinMax() {
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        long l = Util.getTime();
        long l2 = l + 90000L;
        String string = Util.getJRobinDemoPath("minmax.rrd");
        String string2 = Util.getJRobinDemoPath("minmax.png");
        RrdDef rrdDef = new RrdDef(string, l - 1L, 300L);
        rrdDef.addDatasource("a", "GAUGE", 600L, Double.NaN, Double.NaN);
        rrdDef.addArchive("AVERAGE", 0.5, 1, 300);
        rrdDef.addArchive("MIN", 0.5, 12, 300);
        rrdDef.addArchive("MAX", 0.5, 12, 300);
        RrdDb rrdDb = new RrdDb(rrdDef);
        for (long i = l; i < l2; i += 300L) {
            Sample sample = rrdDb.createSample(i);
            sample.setValue("a", Math.sin((double)i / 3000.0) * 50.0 + 50.0);
            sample.update();
        }
        RrdGraphDef rrdGraphDef = new RrdGraphDef();
        rrdGraphDef.setFilename(string2);
        rrdGraphDef.setWidth(450);
        rrdGraphDef.setHeight(250);
        rrdGraphDef.setImageFormat("png");
        rrdGraphDef.setTimeSpan(l, l + 86400L);
        rrdGraphDef.setTitle("RRDTool's MINMAX.pl demo");
        rrdGraphDef.datasource("a", string, "a", "AVERAGE");
        rrdGraphDef.datasource("b", string, "a", "MIN");
        rrdGraphDef.datasource("c", string, "a", "MAX");
        rrdGraphDef.area("a", Color.decode("0xb6e4"), "real");
        rrdGraphDef.line("b", Color.decode("0x22e9"), "min");
        rrdGraphDef.line("c", Color.decode("0xee22"), "max");
        new RrdGraph(rrdGraphDef);
    }
}

